"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _exponentialBackoff = require("exponential-backoff");
var _rxjs = require("rxjs");
var _common = require("@kbn/spaces-plugin/common");
var _server = require("@kbn/core/server");
var _lockManager = require("@kbn/lock-manager");
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _common2 = require("../common");
var _experimental_features = require("../common/experimental_features");
var _constants = require("../common/constants");
var _cache = require("./services/epm/packages/cache");
var _get_files_client_factory = require("./services/files/get_files_client_factory");
var _security = require("./services/security");
var _output_client = require("./services/output_client");
var _constants2 = require("./constants");
var _saved_objects = require("./saved_objects");
var _routes = require("./routes");
var _services = require("./services");
var _register = require("./collectors/register");
var _artifacts = require("./services/artifacts");
var _sender = require("./telemetry/sender");
var _setup = require("./services/setup");
var _agents = require("./services/agents");
var _package_policy = require("./services/package_policy");
var _fleet_usage_logger = require("./services/fleet_usage_logger");
var _check_deleted_files_task = require("./tasks/check_deleted_files_task");
var _unenroll_inactive_agents_task = require("./tasks/unenroll_inactive_agents_task");
var _uninstall_token_service = require("./services/security/uninstall_token_service");
var _actions = require("./services/actions");
var _agent_policy_watch = require("./services/agent_policy_watch");
var _tag_assets = require("./services/epm/kibana/assets/tag_assets");
var _fleet_metrics_task = require("./services/metrics/fleet_metrics_task");
var _fetch_agent_metrics = require("./services/metrics/fetch_agent_metrics");
var _register_fields_metadata_extractors = require("./services/register_fields_metadata_extractors");
var _managed_package_policies = require("./services/setup/managed_package_policies");
var _deploy_agent_policies_task = require("./services/agent_policies/deploy_agent_policies_task");
var _delete_unenrolled_agents_task = require("./tasks/delete_unenrolled_agents_task");
var _bump_agent_policies_task = require("./services/agent_policies/bump_agent_policies_task");
var _upgrade_agentless_deployment = require("./tasks/upgrade_agentless_deployment");
var _sync_integrations_task = require("./tasks/sync_integrations/sync_integrations_task");
var _automatic_agent_upgrade_task = require("./tasks/automatic_agent_upgrade_task");
var _packages_bulk_operations = require("./tasks/packages_bulk_operations");
var _auto_install_content_packages_task = require("./tasks/auto_install_content_packages_task");
var _agent_status_change_task = require("./tasks/agent_status_change_task");
var _setup2 = require("./tasks/setup");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const allSavedObjectTypes = [_constants2.OUTPUT_SAVED_OBJECT_TYPE, _constants.LEGACY_AGENT_POLICY_SAVED_OBJECT_TYPE, _constants.AGENT_POLICY_SAVED_OBJECT_TYPE, _constants.LEGACY_PACKAGE_POLICY_SAVED_OBJECT_TYPE, _constants.PACKAGE_POLICY_SAVED_OBJECT_TYPE, _constants2.PACKAGES_SAVED_OBJECT_TYPE, _constants2.ASSETS_SAVED_OBJECT_TYPE, _constants2.PRECONFIGURATION_DELETION_RECORD_SAVED_OBJECT_TYPE, _constants2.DOWNLOAD_SOURCE_SAVED_OBJECT_TYPE, _constants2.FLEET_SERVER_HOST_SAVED_OBJECT_TYPE, _constants2.FLEET_PROXY_SAVED_OBJECT_TYPE, _constants2.SPACE_SETTINGS_SAVED_OBJECT_TYPE, _constants2.CLOUD_CONNECTOR_SAVED_OBJECT_TYPE];

/**
 * Describes public Fleet plugin contract returned at the `startup` stage.
 */

class FleetPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config$", void 0);
    (0, _defineProperty2.default)(this, "configInitialValue", void 0);
    (0, _defineProperty2.default)(this, "cloud", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "isProductionMode", void 0);
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "kibanaBranch", void 0);
    (0, _defineProperty2.default)(this, "kibanaInstanceId", void 0);
    (0, _defineProperty2.default)(this, "httpSetup", void 0);
    (0, _defineProperty2.default)(this, "securitySetup", void 0);
    (0, _defineProperty2.default)(this, "spacesPluginsStart", void 0);
    (0, _defineProperty2.default)(this, "encryptedSavedObjectsSetup", void 0);
    (0, _defineProperty2.default)(this, "telemetryEventsSender", void 0);
    (0, _defineProperty2.default)(this, "fleetStatus$", void 0);
    (0, _defineProperty2.default)(this, "bulkActionsResolver", void 0);
    (0, _defineProperty2.default)(this, "fleetUsageSender", void 0);
    (0, _defineProperty2.default)(this, "checkDeletedFilesTask", void 0);
    (0, _defineProperty2.default)(this, "fleetMetricsTask", void 0);
    (0, _defineProperty2.default)(this, "unenrollInactiveAgentsTask", void 0);
    (0, _defineProperty2.default)(this, "deleteUnenrolledAgentsTask", void 0);
    (0, _defineProperty2.default)(this, "updateAgentlessDeploymentsTask", void 0);
    (0, _defineProperty2.default)(this, "syncIntegrationsTask", void 0);
    (0, _defineProperty2.default)(this, "automaticAgentUpgradeTask", void 0);
    (0, _defineProperty2.default)(this, "autoInstallContentPackagesTask", void 0);
    (0, _defineProperty2.default)(this, "agentStatusChangeTask", void 0);
    (0, _defineProperty2.default)(this, "agentService", void 0);
    (0, _defineProperty2.default)(this, "packageService", void 0);
    (0, _defineProperty2.default)(this, "packagePolicyService", void 0);
    (0, _defineProperty2.default)(this, "policyWatcher", void 0);
    (0, _defineProperty2.default)(this, "fetchUsage", void 0);
    (0, _defineProperty2.default)(this, "lockManagerService", void 0);
    this.initializerContext = initializerContext;
    this.config$ = this.initializerContext.config.create();
    this.isProductionMode = this.initializerContext.env.mode.prod;
    this.kibanaVersion = this.initializerContext.env.packageInfo.version;
    this.kibanaBranch = this.initializerContext.env.packageInfo.branch;
    this.kibanaInstanceId = this.initializerContext.env.instanceUuid;
    this.logger = this.initializerContext.logger.get();
    this.configInitialValue = this.initializerContext.config.get();
    this.telemetryEventsSender = new _sender.TelemetryEventsSender(this.logger.get('telemetry_events'));
    this.fleetStatus$ = new _rxjs.BehaviorSubject({
      level: _server.ServiceStatusLevels.unavailable,
      summary: 'Fleet is unavailable'
    });
  }
  setup(core, deps) {
    var _config$enableExperim, _config$syncIntegrati, _config$autoUpgrades, _config$autoUpgrades2, _config$autoInstallCo, _config$agentStatusCh;
    this.httpSetup = core.http;
    this.encryptedSavedObjectsSetup = deps.encryptedSavedObjects;
    this.cloud = deps.cloud;
    this.securitySetup = deps.security;
    const config = this.configInitialValue;
    core.status.set(this.fleetStatus$.asObservable());
    const experimentalFeatures = (0, _experimental_features.parseExperimentalConfigValue)((_config$enableExperim = config.enableExperimental) !== null && _config$enableExperim !== void 0 ? _config$enableExperim : []);
    const requireAllSpaces = experimentalFeatures.useSpaceAwareness ? false : true;
    (0, _saved_objects.registerSavedObjects)(core.savedObjects, {
      useSpaceAwareness: experimentalFeatures.useSpaceAwareness
    });
    (0, _saved_objects.registerEncryptedSavedObjects)(deps.encryptedSavedObjects);

    // Register feature
    if (deps.features) {
      deps.features.registerKibanaFeature({
        id: `fleetv2`,
        name: 'Fleet',
        category: _server.DEFAULT_APP_CATEGORIES.management,
        app: [_constants2.PLUGIN_ID],
        catalogue: ['fleet'],
        reserved: {
          description: 'Privilege to setup Fleet packages and configured policies. Intended for use by the elastic/fleet-server service account only.',
          privileges: [{
            id: 'fleet-setup',
            privilege: {
              excludeFromBasePrivileges: true,
              api: ['fleet-setup'],
              savedObject: {
                all: [],
                read: []
              },
              ui: []
            }
          }]
        },
        subFeatures: [{
          name: 'Agents',
          requireAllSpaces,
          privilegeGroups: [{
            groupType: 'mutually_exclusive',
            privileges: [{
              id: `agents_all`,
              api: [`${_constants2.PLUGIN_ID}-agents-read`, `${_constants2.PLUGIN_ID}-agents-all`],
              name: 'All',
              ui: ['agents_read', 'agents_all'],
              savedObject: {
                all: allSavedObjectTypes,
                read: allSavedObjectTypes
              },
              includeIn: 'all'
            }, {
              id: `agents_read`,
              api: [`${_constants2.PLUGIN_ID}-agents-read`],
              name: 'Read',
              ui: ['agents_read'],
              savedObject: {
                all: [],
                read: allSavedObjectTypes
              },
              includeIn: 'read',
              alerting: {}
            }]
          }]
        }, {
          name: 'Agent policies',
          requireAllSpaces,
          privilegeGroups: [{
            groupType: 'mutually_exclusive',
            privileges: [{
              id: `agent_policies_all`,
              api: [`${_constants2.PLUGIN_ID}-agent-policies-read`, `${_constants2.PLUGIN_ID}-agent-policies-all`],
              name: 'All',
              ui: ['agent_policies_read', 'agent_policies_all'],
              savedObject: {
                all: allSavedObjectTypes,
                read: allSavedObjectTypes
              },
              includeIn: 'all'
            }, {
              id: `agent_policies_read`,
              api: [`${_constants2.PLUGIN_ID}-agent-policies-read`],
              name: 'Read',
              ui: ['agent_policies_read'],
              savedObject: {
                all: [],
                read: allSavedObjectTypes
              },
              includeIn: 'read',
              alerting: {}
            }]
          }]
        }, {
          name: 'Settings',
          requireAllSpaces,
          privilegeGroups: [{
            groupType: 'mutually_exclusive',
            privileges: [{
              id: `settings_all`,
              api: [`${_constants2.PLUGIN_ID}-settings-read`, `${_constants2.PLUGIN_ID}-settings-all`],
              name: 'All',
              ui: ['settings_read', 'settings_all'],
              savedObject: {
                all: allSavedObjectTypes,
                read: allSavedObjectTypes
              },
              includeIn: 'all'
            }, {
              id: `settings_read`,
              api: [`${_constants2.PLUGIN_ID}-settings-read`],
              name: 'Read',
              ui: ['settings_read'],
              savedObject: {
                all: [],
                read: allSavedObjectTypes
              },
              includeIn: 'read',
              alerting: {}
            }]
          }]
        }],
        privileges: {
          all: {
            api: [`${_constants2.PLUGIN_ID}-read`, `${_constants2.PLUGIN_ID}-all`],
            app: [_constants2.PLUGIN_ID],
            requireAllSpaces,
            catalogue: ['fleet'],
            savedObject: {
              all: allSavedObjectTypes,
              read: []
            },
            ui: ['read', 'all']
          },
          read: {
            api: [`${_constants2.PLUGIN_ID}-read`],
            app: [_constants2.PLUGIN_ID],
            catalogue: ['fleet'],
            requireAllSpaces,
            savedObject: {
              all: [],
              read: allSavedObjectTypes
            },
            ui: ['read']
          }
        }
      });
      deps.features.registerKibanaFeature({
        id: 'fleet',
        // for BWC
        name: 'Integrations',
        category: _server.DEFAULT_APP_CATEGORIES.management,
        app: [_common2.INTEGRATIONS_PLUGIN_ID],
        catalogue: ['fleet'],
        privileges: {
          all: {
            api: [`${_common2.INTEGRATIONS_PLUGIN_ID}-read`, `${_common2.INTEGRATIONS_PLUGIN_ID}-all`],
            app: [_common2.INTEGRATIONS_PLUGIN_ID],
            catalogue: ['fleet'],
            savedObject: {
              all: allSavedObjectTypes,
              read: []
            },
            ui: ['read', 'all']
          },
          read: {
            api: [`${_common2.INTEGRATIONS_PLUGIN_ID}-read`],
            app: [_common2.INTEGRATIONS_PLUGIN_ID],
            catalogue: ['fleet'],
            savedObject: {
              all: [],
              read: allSavedObjectTypes
            },
            ui: ['read']
          }
        },
        subFeatures: []
      });
    }
    core.http.registerRouteHandlerContext(_constants2.PLUGIN_ID, async (context, request) => {
      const plugin = this;
      const coreContext = await context.core;
      const authz = await (0, _security.getAuthzFromRequest)(request);
      const esClient = coreContext.elasticsearch.client;
      const soClient = coreContext.savedObjects.getClient();
      const routeRequiredAuthz = (0, _security.getRouteRequiredAuthz)(request.route.method, request.route.path);
      const routeAuthz = routeRequiredAuthz ? (0, _security.calculateRouteAuthz)(authz, routeRequiredAuthz) : undefined;
      const getInternalSoClient = () => _services.appContextService.getSavedObjects().getScopedClient(request, {
        excludedExtensions: [_coreSavedObjectsServer.SECURITY_EXTENSION_ID]
      });
      const spacesPluginsStart = this.spacesPluginsStart;
      return {
        get agentClient() {
          const agentService = plugin.setupAgentService(esClient.asInternalUser, soClient);
          return {
            asCurrentUser: agentService.asScoped(request),
            asInternalUser: agentService.asInternalUser
          };
        },
        get uninstallTokenService() {
          const uninstallTokenService = new _uninstall_token_service.UninstallTokenService(_services.appContextService.getEncryptedSavedObjectsStart().getClient({
            includedHiddenTypes: [_common2.UNINSTALL_TOKENS_SAVED_OBJECT_TYPE]
          }), _services.appContextService.getInternalUserSOClientForSpaceId(soClient.getCurrentNamespace()));
          return {
            asCurrentUser: uninstallTokenService
          };
        },
        get packagePolicyService() {
          const service = plugin.setupPackagePolicyService();
          return {
            asCurrentUser: service.asScoped(request),
            asInternalUser: service.asInternalUser
          };
        },
        authz,
        get internalSoClient() {
          // Use a lazy getter to avoid constructing this client when not used by a request handler
          return getInternalSoClient();
        },
        get spaceId() {
          var _deps$spaces$spacesSe, _deps$spaces, _deps$spaces$spacesSe2;
          return (_deps$spaces$spacesSe = (_deps$spaces = deps.spaces) === null || _deps$spaces === void 0 ? void 0 : (_deps$spaces$spacesSe2 = _deps$spaces.spacesService) === null || _deps$spaces$spacesSe2 === void 0 ? void 0 : _deps$spaces$spacesSe2.getSpaceId(request)) !== null && _deps$spaces$spacesSe !== void 0 ? _deps$spaces$spacesSe : _common.DEFAULT_SPACE_ID;
        },
        getAllSpaces() {
          return spacesPluginsStart.spacesService.createSpacesClient(request).getAll();
        },
        get limitedToPackages() {
          if (routeAuthz && routeAuthz.granted) {
            return routeAuthz.scopeDataToPackages;
          }
        }
      };
    });

    // Register usage collection
    (0, _register.registerFleetUsageCollector)(core, config, deps.usageCollection);
    this.fetchUsage = async abortController => await (0, _register.fetchFleetUsage)(core, config, abortController);
    this.fleetUsageSender = new _services.FleetUsageSender(deps.taskManager, core, this.fetchUsage);
    (0, _fleet_usage_logger.registerFleetUsageLogger)(deps.taskManager, async () => (0, _register.fetchAgentsUsage)(core, config));
    const fetchAgents = async abortController => await (0, _fetch_agent_metrics.fetchAgentMetrics)(core, abortController);
    this.fleetMetricsTask = new _fleet_metrics_task.FleetMetricsTask(deps.taskManager, fetchAgents);
    const router = core.http.createRouter();
    // Allow read-only users access to endpoints necessary for Integrations UI
    // Only some endpoints require superuser so we pass a raw IRouter here

    // For all the routes we enforce the user to have role superuser
    const fleetAuthzRouter = (0, _security.makeRouterWithFleetAuthz)(router, this.initializerContext.logger.get('fleet_authz_router'));
    const isServerless = this.initializerContext.env.packageInfo.buildFlavor === 'serverless';
    (0, _routes.registerRoutes)(fleetAuthzRouter, config, isServerless);
    this.telemetryEventsSender.setup(deps.telemetry);
    // Register tasks
    (0, _managed_package_policies.registerUpgradeManagedPackagePoliciesTask)(deps.taskManager);
    (0, _deploy_agent_policies_task.registerDeployAgentPoliciesTask)(deps.taskManager);
    (0, _bump_agent_policies_task.registerBumpAgentPoliciesTask)(deps.taskManager);
    (0, _packages_bulk_operations.registerPackagesBulkOperationTask)(deps.taskManager);
    (0, _setup2.registerSetupTasks)(deps.taskManager);
    this.bulkActionsResolver = new _agents.BulkActionsResolver(deps.taskManager, core);
    this.checkDeletedFilesTask = new _check_deleted_files_task.CheckDeletedFilesTask({
      core,
      taskManager: deps.taskManager,
      logFactory: this.initializerContext.logger
    });
    this.unenrollInactiveAgentsTask = new _unenroll_inactive_agents_task.UnenrollInactiveAgentsTask({
      core,
      taskManager: deps.taskManager,
      logFactory: this.initializerContext.logger
    });
    this.deleteUnenrolledAgentsTask = new _delete_unenrolled_agents_task.DeleteUnenrolledAgentsTask({
      core,
      taskManager: deps.taskManager,
      logFactory: this.initializerContext.logger
    });
    this.updateAgentlessDeploymentsTask = new _upgrade_agentless_deployment.UpgradeAgentlessDeploymentsTask({
      core,
      taskManager: deps.taskManager,
      logFactory: this.initializerContext.logger
    });
    this.syncIntegrationsTask = new _sync_integrations_task.SyncIntegrationsTask({
      core,
      taskManager: deps.taskManager,
      logFactory: this.initializerContext.logger,
      config: {
        taskInterval: (_config$syncIntegrati = config.syncIntegrations) === null || _config$syncIntegrati === void 0 ? void 0 : _config$syncIntegrati.taskInterval
      }
    });
    this.automaticAgentUpgradeTask = new _automatic_agent_upgrade_task.AutomaticAgentUpgradeTask({
      core,
      taskManager: deps.taskManager,
      logFactory: this.initializerContext.logger,
      config: {
        taskInterval: (_config$autoUpgrades = config.autoUpgrades) === null || _config$autoUpgrades === void 0 ? void 0 : _config$autoUpgrades.taskInterval,
        retryDelays: (_config$autoUpgrades2 = config.autoUpgrades) === null || _config$autoUpgrades2 === void 0 ? void 0 : _config$autoUpgrades2.retryDelays
      }
    });
    this.autoInstallContentPackagesTask = new _auto_install_content_packages_task.AutoInstallContentPackagesTask({
      core,
      taskManager: deps.taskManager,
      logFactory: this.initializerContext.logger,
      config: {
        taskInterval: (_config$autoInstallCo = config.autoInstallContentPackages) === null || _config$autoInstallCo === void 0 ? void 0 : _config$autoInstallCo.taskInterval
      }
    });
    this.agentStatusChangeTask = new _agent_status_change_task.AgentStatusChangeTask({
      core,
      taskManager: deps.taskManager,
      logFactory: this.initializerContext.logger,
      config: {
        taskInterval: (_config$agentStatusCh = config.agentStatusChange) === null || _config$agentStatusCh === void 0 ? void 0 : _config$agentStatusCh.taskInterval
      }
    });
    this.lockManagerService = new _lockManager.LockManagerService(core, this.initializerContext.logger.get());

    // Register fields metadata extractors
    (0, _register_fields_metadata_extractors.registerFieldsMetadataExtractors)({
      core,
      fieldsMetadata: deps.fieldsMetadata
    });
  }
  start(core, plugins) {
    var _this$bulkActionsReso, _this$fleetUsageSende, _this$checkDeletedFil, _this$unenrollInactiv, _this$deleteUnenrolle, _this$updateAgentless, _this$automaticAgentU, _this$fleetMetricsTas, _this$syncIntegration, _this$autoInstallCont, _this$agentStatusChan, _this$configInitialVa, _this$configInitialVa2, _this$configInitialVa3;
    this.spacesPluginsStart = plugins.spaces;
    const messageSigningService = new _security.MessageSigningService(this.initializerContext.logger, plugins.encryptedSavedObjects.getClient({
      includedHiddenTypes: [_common2.MESSAGE_SIGNING_KEYS_SAVED_OBJECT_TYPE]
    }));
    const uninstallTokenService = new _uninstall_token_service.UninstallTokenService(plugins.encryptedSavedObjects.getClient({
      includedHiddenTypes: [_common2.UNINSTALL_TOKENS_SAVED_OBJECT_TYPE]
    }));
    _services.appContextService.start({
      elasticsearch: core.elasticsearch,
      data: plugins.data,
      encryptedSavedObjectsStart: plugins.encryptedSavedObjects,
      encryptedSavedObjectsSetup: this.encryptedSavedObjectsSetup,
      securityCoreStart: core.security,
      securitySetup: this.securitySetup,
      securityStart: plugins.security,
      configInitialValue: this.configInitialValue,
      config$: this.config$,
      experimentalFeatures: (0, _experimental_features.parseExperimentalConfigValue)(this.configInitialValue.enableExperimental || []),
      savedObjects: core.savedObjects,
      savedObjectsTagging: plugins.savedObjectsTagging,
      isProductionMode: this.isProductionMode,
      kibanaVersion: this.kibanaVersion,
      kibanaBranch: this.kibanaBranch,
      kibanaInstanceId: this.kibanaInstanceId,
      httpSetup: this.httpSetup,
      cloud: this.cloud,
      logger: this.logger,
      telemetryEventsSender: this.telemetryEventsSender,
      bulkActionsResolver: this.bulkActionsResolver,
      messageSigningService,
      uninstallTokenService,
      unenrollInactiveAgentsTask: this.unenrollInactiveAgentsTask,
      deleteUnenrolledAgentsTask: this.deleteUnenrolledAgentsTask,
      updateAgentlessDeploymentsTask: this.updateAgentlessDeploymentsTask,
      automaticAgentUpgradeTask: this.automaticAgentUpgradeTask,
      taskManagerStart: plugins.taskManager,
      fetchUsage: this.fetchUsage,
      syncIntegrationsTask: this.syncIntegrationsTask,
      lockManagerService: this.lockManagerService,
      autoInstallContentPackagesTask: this.autoInstallContentPackagesTask,
      agentStatusChangeTask: this.agentStatusChangeTask,
      alertingStart: plugins.alerting
    });
    _services.licenseService.start(plugins.licensing.license$);
    this.telemetryEventsSender.start(plugins.telemetry, core).catch(() => {});
    (_this$bulkActionsReso = this.bulkActionsResolver) === null || _this$bulkActionsReso === void 0 ? void 0 : _this$bulkActionsReso.start(plugins.taskManager).catch(() => {});
    (_this$fleetUsageSende = this.fleetUsageSender) === null || _this$fleetUsageSende === void 0 ? void 0 : _this$fleetUsageSende.start(plugins.taskManager).catch(() => {});
    (_this$checkDeletedFil = this.checkDeletedFilesTask) === null || _this$checkDeletedFil === void 0 ? void 0 : _this$checkDeletedFil.start({
      taskManager: plugins.taskManager
    }).catch(() => {});
    (_this$unenrollInactiv = this.unenrollInactiveAgentsTask) === null || _this$unenrollInactiv === void 0 ? void 0 : _this$unenrollInactiv.start({
      taskManager: plugins.taskManager
    }).catch(() => {});
    (_this$deleteUnenrolle = this.deleteUnenrolledAgentsTask) === null || _this$deleteUnenrolle === void 0 ? void 0 : _this$deleteUnenrolle.start({
      taskManager: plugins.taskManager
    }).catch(() => {});
    (_this$updateAgentless = this.updateAgentlessDeploymentsTask) === null || _this$updateAgentless === void 0 ? void 0 : _this$updateAgentless.start({
      taskManager: plugins.taskManager
    }).catch(() => {});
    (_this$automaticAgentU = this.automaticAgentUpgradeTask) === null || _this$automaticAgentU === void 0 ? void 0 : _this$automaticAgentU.start({
      taskManager: plugins.taskManager
    }).catch(() => {});
    (0, _fleet_usage_logger.startFleetUsageLogger)(plugins.taskManager).catch(() => {});
    (_this$fleetMetricsTas = this.fleetMetricsTask) === null || _this$fleetMetricsTas === void 0 ? void 0 : _this$fleetMetricsTas.start(plugins.taskManager, core.elasticsearch.client.asInternalUser).catch(() => {});
    (_this$syncIntegration = this.syncIntegrationsTask) === null || _this$syncIntegration === void 0 ? void 0 : _this$syncIntegration.start({
      taskManager: plugins.taskManager
    }).catch(() => {});
    (_this$autoInstallCont = this.autoInstallContentPackagesTask) === null || _this$autoInstallCont === void 0 ? void 0 : _this$autoInstallCont.start({
      taskManager: plugins.taskManager
    }).catch(() => {});
    (_this$agentStatusChan = this.agentStatusChangeTask) === null || _this$agentStatusChan === void 0 ? void 0 : _this$agentStatusChan.start({
      taskManager: plugins.taskManager
    }).catch(() => {});
    const logger = _services.appContextService.getLogger();
    this.policyWatcher = new _agent_policy_watch.PolicyWatcher(logger);
    this.policyWatcher.start(_services.licenseService);
    const setupAttempts = (_this$configInitialVa = this.configInitialValue.internal) !== null && _this$configInitialVa !== void 0 && _this$configInitialVa.retrySetupOnBoot ? 25 : 1;
    const fleetSetupPromise = (async () => {
      try {
        // Fleet remains `available` during setup as to excessively delay Kibana's boot process.
        // This should be reevaluated as Fleet's setup process is optimized and stabilized.
        this.fleetStatus$.next({
          level: _server.ServiceStatusLevels.available,
          summary: 'Fleet is setting up'
        });

        // We need to wait for the licence feature to be available,
        // to have our internal saved object client with encrypted saved object working properly
        await plugins.licensing.license$.pipe((0, _rxjs.filter)(licence => licence.getFeature('security').isEnabled && licence.getFeature('security').isAvailable), (0, _rxjs.take)(1)).toPromise();
        const randomIntFromInterval = (min, max) => {
          return Math.floor(Math.random() * (max - min + 1) + min);
        };

        // Retry Fleet setup w/ backoff
        await (0, _exponentialBackoff.backOff)(async () => {
          await (0, _setup.setupFleet)(new _server.SavedObjectsClient(core.savedObjects.createInternalRepository()), core.elasticsearch.client.asInternalUser, {
            useLock: true
          });
        }, {
          numOfAttempts: setupAttempts,
          delayFirstAttempt: true,
          // 1s initial backoff
          startingDelay: randomIntFromInterval(100, 1000),
          // 5m max backoff
          maxDelay: 60000 * 5,
          timeMultiple: 2,
          // avoid HA contention with other Kibana instances
          jitter: 'full',
          retry: (error, attemptCount) => {
            const summary = `Fleet setup attempt ${attemptCount} failed, will retry after backoff`;
            logger.warn(summary, {
              error
            });
            this.fleetStatus$.next({
              level: _server.ServiceStatusLevels.available,
              summary,
              meta: {
                attemptCount,
                error
              }
            });
            return true;
          }
        });

        // initialize (generate/encrypt/validate) Uninstall Tokens asynchronously
        this.initializeUninstallTokens().catch(() => {});
        this.fleetStatus$.next({
          level: _server.ServiceStatusLevels.available,
          summary: 'Fleet is available'
        });
      } catch (error) {
        logger.warn(`Fleet setup failed after ${setupAttempts} attempts`, {
          error
        });
        this.fleetStatus$.next({
          // As long as Fleet has a dependency on EPR, we can't reliably set Kibana status to `unavailable` here.
          // See https://github.com/elastic/kibana/issues/120237
          level: _server.ServiceStatusLevels.available,
          summary: 'Fleet setup failed',
          meta: {
            error: error.message
          }
        });
      }
    })();
    const internalSoClient = new _server.SavedObjectsClient(core.savedObjects.createInternalRepository());
    return {
      authz: {
        fromRequest: _security.getAuthzFromRequest
      },
      agentless: {
        enabled: (_this$configInitialVa2 = (_this$configInitialVa3 = this.configInitialValue.agentless) === null || _this$configInitialVa3 === void 0 ? void 0 : _this$configInitialVa3.enabled) !== null && _this$configInitialVa2 !== void 0 ? _this$configInitialVa2 : false
      },
      fleetSetupCompleted: () => fleetSetupPromise,
      packageService: this.setupPackageService(core.elasticsearch.client.asInternalUser, internalSoClient),
      agentService: this.setupAgentService(core.elasticsearch.client.asInternalUser, internalSoClient),
      agentPolicyService: _services.agentPolicyService,
      packagePolicyService: _services.packagePolicyService,
      registerExternalCallback: (type, callback) => {
        return _services.appContextService.addExternalCallback(type, callback);
      },
      createArtifactsClient(packageName) {
        return new _artifacts.FleetArtifactsClient(core.elasticsearch.client.asInternalUser, packageName);
      },
      createFilesClient: Object.freeze((0, _get_files_client_factory.getFilesClientFactory)({
        esClient: core.elasticsearch.client.asInternalUser,
        logger: this.initializerContext.logger
      })),
      messageSigningService,
      uninstallTokenService,
      createFleetActionsClient(packageName) {
        return new _actions.FleetActionsClient(core.elasticsearch.client.asInternalUser, packageName);
      },
      getPackageSpecTagId: _tag_assets.getPackageSpecTagId,
      async createOutputClient(request) {
        const soClient = _services.appContextService.getSavedObjects().getScopedClient(request);
        const authz = await (0, _security.getAuthzFromRequest)(request);
        return new _output_client.OutputClient(soClient, authz);
      },
      cloudConnectorService: _services.cloudConnectorService,
      runWithCache: _cache.runWithCache
    };
  }
  stop() {
    var _this$policyWatcher;
    _services.appContextService.stop();
    (_this$policyWatcher = this.policyWatcher) === null || _this$policyWatcher === void 0 ? void 0 : _this$policyWatcher.stop();
    _services.licenseService.stop();
    this.telemetryEventsSender.stop();
    this.fleetStatus$.complete();
  }
  setupAgentService(internalEsClient, internalSoClient) {
    if (this.agentService) {
      return this.agentService;
    }
    this.agentService = new _services.AgentServiceImpl(internalEsClient, internalSoClient);
    return this.agentService;
  }
  setupPackagePolicyService() {
    if (this.packagePolicyService) {
      return this.packagePolicyService;
    }
    this.packagePolicyService = new _package_policy.PackagePolicyServiceImpl();
    return this.packagePolicyService;
  }
  setupPackageService(internalEsClient, internalSoClient) {
    if (this.packageService) {
      return this.packageService;
    }
    this.packageService = new _services.PackageServiceImpl(internalEsClient, internalSoClient, this.getLogger());
    return this.packageService;
  }
  getLogger() {
    if (!this.logger) {
      this.logger = this.initializerContext.logger.get();
    }
    return this.logger;
  }
  async initializeUninstallTokens() {
    try {
      await this.generateUninstallTokens();
    } catch (error) {
      _services.appContextService.getLogger().error('Error happened during uninstall token generation.', {
        error
      });
    }
    try {
      await this.validateUninstallTokens();
    } catch (error) {
      _services.appContextService.getLogger().error('Error happened during uninstall token validation.', {
        error
      });
    }
  }
  async generateUninstallTokens() {
    var _appContextService$ge, _appContextService$ge2, _appContextService$ge3;
    const logger = _services.appContextService.getLogger();
    logger.debug('Generating Agent uninstall tokens');
    if (!((_appContextService$ge = _services.appContextService.getEncryptedSavedObjectsSetup()) !== null && _appContextService$ge !== void 0 && _appContextService$ge.canEncrypt)) {
      logger.warn('xpack.encryptedSavedObjects.encryptionKey is not configured, agent uninstall tokens are being stored in plain text');
    }
    await ((_appContextService$ge2 = _services.appContextService.getUninstallTokenService()) === null || _appContextService$ge2 === void 0 ? void 0 : _appContextService$ge2.generateTokensForAllPolicies());
    if ((_appContextService$ge3 = _services.appContextService.getEncryptedSavedObjectsSetup()) !== null && _appContextService$ge3 !== void 0 && _appContextService$ge3.canEncrypt) {
      var _appContextService$ge4;
      logger.debug('Checking for and encrypting plain text uninstall tokens');
      await ((_appContextService$ge4 = _services.appContextService.getUninstallTokenService()) === null || _appContextService$ge4 === void 0 ? void 0 : _appContextService$ge4.encryptTokens());
    }
  }
  async validateUninstallTokens() {
    var _appContextService$ge5;
    const logger = _services.appContextService.getLogger();
    logger.debug('Validating uninstall tokens');
    const unintallTokenValidationError = await ((_appContextService$ge5 = _services.appContextService.getUninstallTokenService()) === null || _appContextService$ge5 === void 0 ? void 0 : _appContextService$ge5.checkTokenValidityForAllPolicies());
    if (unintallTokenValidationError) {
      logger.warn(unintallTokenValidationError.error.message);
    } else {
      logger.debug('Uninstall tokens validation successful.');
    }
  }
}
exports.FleetPlugin = FleetPlugin;