"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackagePolicyActionsMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../hooks");
var _services = require("../services");
var _agent_enrollment_flyout = require("./agent_enrollment_flyout");
var _context_menu_actions = require("./context_menu_actions");
var _danger_eui_context_menu_item = require("./danger_eui_context_menu_item");
var _package_policy_delete_provider = require("./package_policy_delete_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/components/package_policy_actions_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PackagePolicyActionsMenu = ({
  agentPolicies,
  packagePolicy,
  showAddAgent,
  upgradePackagePolicyHref,
  defaultIsOpen = false,
  from
}) => {
  var _agentPolicy$id, _packagePolicy$packag, _packagePolicy$packag2;
  const [isEnrollmentFlyoutOpen, setIsEnrollmentFlyoutOpen] = (0, _react.useState)(false);
  const {
    getHref
  } = (0, _hooks.useLink)();
  const authz = (0, _hooks.useAuthz)();
  const agentPolicy = agentPolicies.length > 0 ? agentPolicies[0] : undefined;
  const canWriteIntegrationPolicies = authz.integrations.writeIntegrationPolicies;
  const isFleetServerPolicy = agentPolicy && (0, _services.policyHasFleetServer)(agentPolicy);
  const canAddAgents = isFleetServerPolicy ? authz.fleet.addFleetServers : authz.fleet.addAgents;
  const refreshAgentPolicy = (0, _hooks.useAgentPolicyRefresh)();
  const [isActionsMenuOpen, setIsActionsMenuOpen] = (0, _react.useState)(defaultIsOpen);
  const isManaged = Boolean(packagePolicy.is_managed);
  const agentPolicyIsManaged = Boolean(agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.is_managed);
  const isOrphanedPolicy = !agentPolicy && packagePolicy.policy_ids.length === 0;
  const isAgentlessPolicy = packagePolicy.supports_agentless;
  const isAddAgentVisible = showAddAgent && agentPolicy && !agentPolicyIsManaged && !(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.supports_agentless);
  const onEnrollmentFlyoutClose = (0, _react.useMemo)(() => {
    return () => setIsEnrollmentFlyoutOpen(false);
  }, []);
  const menuItems = [
  // FIXME: implement View package policy action
  // <EuiContextMenuItem
  //   disabled
  //   icon="inspect"
  //   onClick={() => {}}
  //   key="packagePolicyView"
  // >
  //   <FormattedMessage
  //     id="xpack.fleet.policyDetails.packagePoliciesTable.viewActionTitle"
  //     defaultMessage="View integration"
  //   />
  // </EuiContextMenuItem>,
  ...(isAddAgentVisible ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "PackagePolicyActionsAddAgentItem",
    icon: "plusInCircle",
    onClick: () => {
      setIsActionsMenuOpen(false);
      setIsEnrollmentFlyoutOpen(true);
    },
    key: "addAgent",
    disabled: !canAddAgents,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.packageDetails.integrationList.addAgent",
    defaultMessage: "Add agent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  }))] : []), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "PackagePolicyActionsEditItem",
    disabled: !canWriteIntegrationPolicies || !agentPolicy && !isOrphanedPolicy,
    icon: "pencil",
    href: `${isOrphanedPolicy || isAgentlessPolicy ? getHref('integration_policy_edit', {
      packagePolicyId: packagePolicy.id
    }) : getHref('edit_integration', {
      policyId: (_agentPolicy$id = agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id) !== null && _agentPolicy$id !== void 0 ? _agentPolicy$id : '',
      packagePolicyId: packagePolicy.id
    })}${from ? `?from=${from}` : ''}`,
    key: "packagePolicyEdit",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.policyDetails.packagePoliciesTable.editActionTitle",
    defaultMessage: "Edit integration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  })), ...(packagePolicy.hasUpgrade ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "PackagePolicyActionsUpgradeItem",
    disabled: !canWriteIntegrationPolicies || !upgradePackagePolicyHref,
    icon: "refresh",
    href: upgradePackagePolicyHref,
    key: "packagePolicyUpgrade",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.policyDetails.packagePoliciesTable.upgradeActionTitle",
    "data-test-subj": "UpgradeIntegrationPolicy",
    defaultMessage: "Upgrade integration policy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }))] : [])
  // FIXME: implement Copy package policy action
  // <EuiContextMenuItem disabled icon="copy" onClick={() => {}} key="packagePolicyCopy">
  //   <FormattedMessage
  //     id="xpack.fleet.policyDetails.packagePoliciesTable.copyActionTitle"
  //     defaultMessage="Copy integration"
  //   />
  // </EuiContextMenuItem>,
  ];
  if (!agentPolicy || !agentPolicyIsManaged || agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.supports_agentless) {
    const ContextMenuItem = canWriteIntegrationPolicies ? _danger_eui_context_menu_item.DangerEuiContextMenuItem : _eui.EuiContextMenuItem;
    menuItems.push(/*#__PURE__*/_react.default.createElement(_package_policy_delete_provider.PackagePolicyDeleteProvider, {
      from: from,
      agentPolicies: agentPolicies,
      key: "packagePolicyDelete",
      packagePolicyPackage: packagePolicy.package,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 7
      }
    }, deletePackagePoliciesPrompt => {
      return /*#__PURE__*/_react.default.createElement(ContextMenuItem, {
        "data-test-subj": "PackagePolicyActionsDeleteItem",
        disabled: !canWriteIntegrationPolicies,
        icon: "trash",
        onClick: () => {
          deletePackagePoliciesPrompt([packagePolicy.id], () => {
            setIsActionsMenuOpen(false);
            refreshAgentPolicy();
          });
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 151,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.policyDetails.packagePoliciesTable.deleteActionTitle",
        defaultMessage: "Delete integration",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 162,
          columnNumber: 15
        }
      }));
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isEnrollmentFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_enrollment_flyout.AgentEnrollmentFlyout, {
    agentPolicy: agentPolicies.length === 1 ? agentPolicies[0] : undefined // in case of multiple policies, show the selector in the flyout
    ,
    selectedAgentPolicies: agentPolicies,
    onClose: onEnrollmentFlyoutClose,
    isIntegrationFlow: true,
    installedPackagePolicy: {
      name: (packagePolicy === null || packagePolicy === void 0 ? void 0 : (_packagePolicy$packag = packagePolicy.package) === null || _packagePolicy$packag === void 0 ? void 0 : _packagePolicy$packag.name) || '',
      version: (packagePolicy === null || packagePolicy === void 0 ? void 0 : (_packagePolicy$packag2 = packagePolicy.package) === null || _packagePolicy$packag2 === void 0 ? void 0 : _packagePolicy$packag2.version) || ''
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_context_menu_actions.ContextMenuActions, {
    isManaged: isManaged,
    isOpen: isActionsMenuOpen,
    items: menuItems,
    onChange: open => setIsActionsMenuOpen(open),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 7
    }
  }));
};
exports.PackagePolicyActionsMenu = PackagePolicyActionsMenu;