"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreatePackagePolicyMultiPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _services = require("../../../../../../../common/services");
var _hooks = require("../../../../hooks");
var _hooks2 = require("./hooks");
var _components = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/multi_page_layout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const installAgentStep = {
  title: _i18n.i18n.translate('xpack.fleet.createFirstPackagePolicy.installAgentStepTitle', {
    defaultMessage: 'Install Elastic Agent'
  }),
  component: _components.InstallElasticAgentPageStep
};
const addIntegrationStep = {
  title: _i18n.i18n.translate('xpack.fleet.createFirstPackagePolicy.addIntegrationStepTitle', {
    defaultMessage: 'Add the integration'
  }),
  component: _components.AddIntegrationPageStep
};
const confirmDataStep = {
  title: _i18n.i18n.translate('xpack.fleet.createFirstPackagePolicy.confirmDataStepTitle', {
    defaultMessage: 'Confirm incoming data'
  }),
  component: _components.ConfirmDataPageStep
};
const fleetManagedSteps = [installAgentStep, addIntegrationStep, confirmDataStep];
const standaloneSteps = [addIntegrationStep, installAgentStep, confirmDataStep];
const CreatePackagePolicyMultiPage = ({
  queryParamsPolicyId,
  prerelease
}) => {
  const {
    params
  } = (0, _reactRouterDom.useRouteMatch)();
  const {
    pkgkey,
    policyId,
    integration
  } = params;
  const {
    pkgName,
    pkgVersion
  } = (0, _services.splitPkgKey)(pkgkey);
  const [onSplash, setOnSplash] = (0, _react.useState)(true);
  const [currentStep, setCurrentStep] = (0, _react.useState)(0);
  const [isManaged, setIsManaged] = (0, _react.useState)(true);
  const {
    getHref
  } = (0, _hooks.useLink)();
  const [enrolledAgentIds, setEnrolledAgentIds] = (0, _react.useState)([]);
  const toggleIsManaged = newIsManaged => {
    setIsManaged(newIsManaged);
    setCurrentStep(0);
  };
  const agentPolicyId = policyId || queryParamsPolicyId;
  const {
    data: packageInfoData,
    error: packageInfoError,
    isLoading: isPackageInfoLoading
  } = (0, _hooks.useGetPackageInfoByKeyQuery)(pkgName, pkgVersion, {
    prerelease,
    full: true
  });
  const {
    agentPolicy,
    enrollmentAPIKey,
    error: agentPolicyError,
    isLoading: isAgentPolicyLoading
  } = (0, _hooks2.useGetAgentPolicyOrDefault)(agentPolicyId);
  const packageInfo = (0, _react.useMemo)(() => packageInfoData === null || packageInfoData === void 0 ? void 0 : packageInfoData.item, [packageInfoData]);
  const integrationInfo = (0, _react.useMemo)(() => {
    var _packageInfo$policy_t;
    if (!integration) return;
    return packageInfo === null || packageInfo === void 0 ? void 0 : (_packageInfo$policy_t = packageInfo.policy_templates) === null || _packageInfo$policy_t === void 0 ? void 0 : _packageInfo$policy_t.find(policyTemplate => policyTemplate.name === integration);
  }, [packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.policy_templates, integration]);
  const splashScreenNext = () => {
    setOnSplash(false);
  };
  const {
    fleetServerHost,
    fleetProxy,
    downloadSource,
    isLoadingInitialRequest
  } = (0, _hooks.useFleetServerHostsForPolicy)(agentPolicy);
  const cancelUrl = getHref('add_integration_to_policy', {
    pkgkey,
    useMultiPageLayout: false,
    ...(integration ? {
      integration
    } : {}),
    ...(agentPolicyId ? {
      agentPolicyId
    } : {}),
    ...(prerelease ? {
      prerelease: 'true'
    } : {})
  });
  if (onSplash || !packageInfo) {
    return /*#__PURE__*/_react.default.createElement(_components.AddFirstIntegrationSplashScreen, {
      isLoading: isPackageInfoLoading || isLoadingInitialRequest || isAgentPolicyLoading,
      error: packageInfoError || agentPolicyError,
      integrationInfo: integrationInfo,
      packageInfo: packageInfo,
      cancelUrl: cancelUrl,
      onNext: splashScreenNext,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 7
      }
    });
  }
  const steps = isManaged ? fleetManagedSteps : standaloneSteps;
  const stepsNext = () => {
    if (currentStep === steps.length - 1) {
      return;
    }
    setCurrentStep(currentStep + 1);
  };
  const stepsBack = () => {
    if (currentStep === 0) {
      return;
    }
    setCurrentStep(currentStep - 1);
  };
  return /*#__PURE__*/_react.default.createElement(_components.MultiPageStepsLayout, {
    fleetServerHost: fleetServerHost,
    fleetProxy: fleetProxy,
    downloadSource: downloadSource,
    agentPolicy: agentPolicy,
    enrollmentAPIKey: enrollmentAPIKey,
    currentStep: currentStep,
    steps: steps,
    packageInfo: packageInfo,
    integrationInfo: integrationInfo,
    cancelUrl: cancelUrl,
    onNext: stepsNext,
    onBack: stepsBack,
    isManaged: isManaged,
    setIsManaged: toggleIsManaged,
    setEnrolledAgentIds: setEnrolledAgentIds,
    enrolledAgentIds: enrolledAgentIds,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 5
    }
  });
};
exports.CreatePackagePolicyMultiPage = CreatePackagePolicyMultiPage;