"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationBreadcrumb = void 0;
var _hooks = require("../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IntegrationBreadcrumb = ({
  pkgTitle,
  pkgkey,
  integration
}) => {
  (0, _hooks.useBreadcrumbs)('add_integration_to_policy', {
    pkgTitle,
    pkgkey,
    ...(integration ? {
      integration
    } : {})
  });
  return null;
};
exports.IntegrationBreadcrumb = IntegrationBreadcrumb;