"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QuickStartTab = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _hooks = require("./hooks");
var _steps = require("./steps");
var _use_latest_fleet_servers = require("./hooks/use_latest_fleet_servers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/components/fleet_server_instructions/quick_start_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const QuickStartTab = ({
  onClose
}) => {
  const {
    fleetServerHost,
    setFleetServerHost,
    fleetServerHosts,
    fleetServerPolicyId,
    serviceToken,
    status,
    error,
    submit,
    inputs
  } = (0, _hooks.useQuickStartCreateForm)();
  const {
    isFleetServerReady
  } = (0, _hooks.useWaitForFleetServer)();
  const {
    hasRecentlyEnrolledFleetServers
  } = (0, _use_latest_fleet_servers.useLatestFleetServers)();
  const steps = [(0, _steps.getGettingStartedStep)({
    fleetServerHosts,
    fleetServerHost,
    setFleetServerHost,
    fleetServerPolicyId,
    serviceToken,
    status,
    error,
    submit,
    isFleetServerHostSubmitted: false,
    inputs,
    onClose
  }), (0, _steps.getInstallFleetServerStep)({
    isFleetServerReady,
    fleetServerHost,
    fleetServerPolicyId,
    serviceToken,
    deploymentMode: 'quickstart',
    disabled: status !== 'success'
  }), (0, _steps.getConfirmFleetServerConnectionStep)({
    hasRecentlyEnrolledFleetServers,
    disabled: status !== 'success'
  })];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: steps,
    className: "eui-textLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 10
    }
  });
};
exports.QuickStartTab = QuickStartTab;