"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangeListeners = void 0;
var _react = _interopRequireWildcard(require("react"));
var _addonActions = require("@storybook/addon-actions");
var _eui = require("@elastic/eui");
var _components = require("../../../components");
var _use_form_data = require("../../hooks/use_form_data");
var _use_field = require("../use_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/es_ui_shared/static/forms/hook_form_lib/components/__stories__/use_field_change_listeners.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * This Story outputs the order in which different state update
 * and events occur whenever a field value changes.
 */
const ChangeListeners = () => {
  const onUseFormDataChange = ({
    title
  }) => {
    (0, _addonActions.action)('1. useFormData() -> onChange() handler')(title);
  };
  const [{
    title
  }] = (0, _use_form_data.useFormData)({
    watch: 'title',
    onChange: onUseFormDataChange
  });
  const onFieldChangeProp = value => {
    (0, _addonActions.action)('2. onChange() prop handler')(value);
  };
  (0, _react.useEffect)(() => {
    (0, _addonActions.action)('4. useEffect() "title" changed')(title);
    (0, _addonActions.action)('')('----------------------------------');
  }, [title]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 11
    }
  }, "Info: start writing in the field and see the order of change listeners appear in the \"Actions\" panel below."))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_use_field.UseField, {
    path: "title",
    component: _components.TextField,
    config: {
      label: 'Title',
      helpText: 'This is a help text for the field.',
      validations: [{
        validator: ({
          value
        }) => {
          (0, _addonActions.action)('3. Validating "title" field')(value);
        }
      }]
    },
    onChange: onFieldChangeProp,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }));
};
exports.ChangeListeners = ChangeListeners;
ChangeListeners.storyName = 'ChangeListeners';
ChangeListeners.parameters = {
  docs: {
    source: {
      code: `
const MyFormComponent = () => {
  const { form } = useForm({ defaultValue });

  const onUseFormDataChange = ({ title }: { title: string }) => {
    action('1. useFormData() -> onChange() handler')(title);
  };
  const [{ title }] = useFormData({ watch: 'title', onChange: onUseFormDataChange });

  const onFieldChangeProp = (value: string) => {
    action('2. onChange() prop handler')(value);
  };

  useEffect(() => {
    action('4. useEffect() "title" changed')(title);
    action('')('----------------------------------');
  }, [title]);

  const submitForm = async () => {
    const { isValid, data } = await form.submit();
    if (isValid) {
      // ... do something with the data
    }
  };

  return (
    <Form form={form}>
      <EuiText>
        <p>
          <EuiTextColor color="subdued">
            Info: start writing in the field and see the order of change listeners appear in the
            &quot;Actions&quot; panel below.
          </EuiTextColor>
        </p>
      </EuiText>
      <EuiSpacer />
      <UseField<string>
        path="title"
        component={TextField}
        config={{
          label: 'Title',
          helpText: 'This is a help text for the field.',
          validations: [
            {
              validator: ({ value }) => {
                action('3. Validating "title" field')(value);
              },
            },
          ],
        }}
        onChange={onFieldChangeProp}
      />
      <EuiSpacer />
      <EuiButton onClick={submitForm}>Send</EuiButton>
    </Form>
  );
};
      `,
      language: 'tsx'
    }
  }
};