"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageLicenseButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _doc_links = require("../doc_links");
var _react_router_helpers = require("../react_router_helpers");
var _licensing_logic = require("./licensing_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/shared/licensing/manage_license_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ManageLicenseButton = props => {
  const {
    canManageLicense
  } = (0, _kea.useValues)(_licensing_logic.LicensingLogic);
  return canManageLicense ? /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, (0, _extends2.default)({
    color: "success"
  }, props, {
    to: "/app/management/stack/license_management",
    shouldNotCreateHref: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }), _i18n.i18n.translate('xpack.enterpriseSearch.licenseManagementLink', {
    defaultMessage: 'Manage your license'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, props, {
    target: "_blank",
    iconType: "popout",
    href: _doc_links.docLinks.licenseManagement,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }), _i18n.i18n.translate('xpack.enterpriseSearch.licenseDocumentationLink', {
    defaultMessage: 'Learn more about license features'
  }));
};
exports.ManageLicenseButton = ManageLicenseButton;