"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigurePipelineTabId = exports.ConfigurePipeline = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _index_view_logic = require("../../index_view_logic");
var _ml_inference_logic = require("./ml_inference_logic");
var _model_select = require("./model_select");
var _model_select_logic = require("./model_select_logic");
var _pipeline_select = require("./pipeline_select");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/pipelines/ml_inference/configure_pipeline.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CREATE_NEW_TAB_NAME = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.tabs.createNew.name', {
  defaultMessage: 'Create new'
});
const USE_EXISTING_TAB_NAME = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.tabs.useExisting.name', {
  defaultMessage: 'Use existing'
});
let ConfigurePipelineTabId = exports.ConfigurePipelineTabId = /*#__PURE__*/function (ConfigurePipelineTabId) {
  ConfigurePipelineTabId["CREATE_NEW"] = "create_new";
  ConfigurePipelineTabId["USE_EXISTING"] = "use_existing";
  return ConfigurePipelineTabId;
}({});
const ConfigurePipeline = () => {
  const {
    addInferencePipelineModal: {
      configuration
    },
    formErrors
  } = (0, _kea.useValues)(_ml_inference_logic.MLInferenceLogic);
  const {
    setInferencePipelineConfiguration
  } = (0, _kea.useActions)(_ml_inference_logic.MLInferenceLogic);
  const {
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    modelStateChangeError
  } = (0, _kea.useValues)(_model_select_logic.ModelSelectLogic);
  const {
    existingPipeline,
    pipelineName
  } = configuration;
  const nameError = formErrors.pipelineName !== undefined && pipelineName.length > 0;
  const inputsDisabled = configuration.existingPipeline !== false;
  const tabs = [{
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      component: "form",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.nameLabel', {
        defaultMessage: 'Name'
      }),
      helpText: !nameError && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 19
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.name.helpText', {
        defaultMessage: 'Pipeline names are unique within a deployment and can only contain letters, numbers, underscores, and hyphens. This will create a pipeline named {pipelineName}.',
        values: {
          pipelineName: `ml-inference-${pipelineName}`
        }
      })),
      error: nameError && formErrors.pipelineName,
      isInvalid: nameError,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      isInvalid: nameError,
      "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-configureInferencePipeline-uniqueName`,
      disabled: inputsDisabled,
      fullWidth: true,
      prepend: "ml-inference-",
      placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.namePlaceholder', {
        defaultMessage: 'Enter a unique name for this pipeline'
      }),
      value: pipelineName,
      onChange: e => setInferencePipelineConfiguration({
        ...configuration,
        isPipelineNameUserSupplied: e.target.value.length > 0,
        pipelineName: e.target.value
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 15
      }
    })), modelStateChangeError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.modelStateChangeError.title', {
        defaultMessage: 'Error changing model state'
      }),
      color: "danger",
      iconType: "error",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 17
      }
    }, modelStateChangeError), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.titleSelectTrainedModel', {
        defaultMessage: 'Select a trained ML Model'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_model_select.ModelSelect, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 15
      }
    })))),
    id: ConfigurePipelineTabId.CREATE_NEW,
    name: CREATE_NEW_TAB_NAME
  }, {
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      component: "form",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.existingPipelineLabel', {
        defaultMessage: 'Select an existing inference pipeline'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_pipeline_select.PipelineSelect, {
      "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-configureInferencePipeline-selectExistingPipeline`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 15
      }
    })))),
    id: ConfigurePipelineTabId.USE_EXISTING,
    name: USE_EXISTING_TAB_NAME
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.title', {
    defaultMessage: 'Configure a pipeline'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.description', {
    defaultMessage: 'Build or reuse a child pipeline that will be used as a processor in your main pipeline.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    autoFocus: "selected",
    initialSelectedTab: tabs[existingPipeline ? 1 : 0],
    onTabClick: tab => {
      const isExistingPipeline = tab.id === ConfigurePipelineTabId.USE_EXISTING;
      if (isExistingPipeline !== configuration.existingPipeline) {
        setInferencePipelineConfiguration({
          ..._ml_inference_logic.EMPTY_PIPELINE_CONFIGURATION,
          existingPipeline: isExistingPipeline
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 7
    }
  }));
};
exports.ConfigurePipeline = ConfigurePipeline;