"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TrainedModelHealthPopover = exports.InferencePipelineCard = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _pipelines = require("../../../../../../common/types/pipelines");
var _constants = require("../../../../shared/constants");
var _http = require("../../../../shared/http");
var _routes = require("../../../routes");
var _utils = require("../../shared/ml_inference/utils");
var _index_name_logic = require("../index_name_logic");
var _index_view_logic = require("../index_view_logic");
var _delete_inference_pipeline_button = require("./delete_inference_pipeline_button");
var _utils2 = require("./ml_inference/utils");
var _ml_model_health = require("./ml_model_health");
var _ml_model_type_badge = require("./ml_model_type_badge");
var _pipelines_logic = require("./pipelines_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/pipelines/inference_pipeline_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TrainedModelHealthPopover = pipeline => {
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  const {
    indexName
  } = (0, _kea.useValues)(_index_name_logic.IndexNameLogic);
  const {
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    deleteMlPipeline,
    detachMlPipeline
  } = (0, _kea.useActions)(_pipelines_logic.PipelinesLogic);
  const [isPopOverOpen, setIsPopOverOpen] = (0, _react.useState)(false);
  const [showConfirmDelete, setShowConfirmDelete] = (0, _react.useState)(false);
  const {
    pipelineName
  } = pipeline;
  const actionButton = /*#__PURE__*/_react.default.createElement(_ml_model_health.TrainedModelHealth, {
    modelState: pipeline.modelState,
    modelStateReason: pipeline.modelStateReason,
    onClickAction: () => setIsPopOverOpen(!isPopOverOpen),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  });
  const showConfirmDeleteModal = () => {
    setShowConfirmDelete(true);
    setIsPopOverOpen(false);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: actionButton,
    isOpen: isPopOverOpen,
    closePopover: () => setIsPopOverOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, pipeline.modelState === _pipelines.TrainedModelState.NotDeployed && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "enterpriseSearchTrainedModelHealthPopoverFixIssueInTrainedModelsButton",
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-inferencePipeline-fixIssueInTrainedModels`,
    size: "s",
    flush: "both",
    iconType: "wrench",
    color: "text",
    href: http.basePath.prepend(_routes.ML_MANAGE_TRAINED_MODELS_PATH),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.modelState.notDeployed.fixLink', {
    defaultMessage: 'Fix issue in Trained Models'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "enterpriseSearchTrainedModelHealthPopoverViewInStackManagementButton",
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-inferencePipeline-stackManagement`,
    size: "s",
    flush: "both",
    iconType: "eye",
    color: "text",
    href: http.basePath.prepend(`/app/management/ingest/ingest_pipelines/?pipeline=${pipelineName}`),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.action.view', {
    defaultMessage: 'View in Stack Management'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "enterpriseSearchTrainedModelHealthPopoverDetachPipelineButton",
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-inferencePipeline-detachPipeline`,
    size: "s",
    flush: "both",
    iconType: "unlink",
    color: "text",
    onClick: () => {
      detachMlPipeline({
        indexName,
        pipelineName
      });
      setIsPopOverOpen(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.action.detach', {
    defaultMessage: 'Detach pipeline'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_delete_inference_pipeline_button.DeleteInferencePipelineButton, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-inferencePipeline-deletePipeline`,
    onClick: showConfirmDeleteModal,
    pipeline: pipeline,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 15
    }
  }))))), showConfirmDelete && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    onCancel: () => setShowConfirmDelete(false),
    onConfirm: () => {
      setShowConfirmDelete(false);
      deleteMlPipeline({
        indexName,
        pipelineName
      });
    },
    title: _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.deleteConfirm.title', {
      defaultMessage: 'Delete Pipeline'
    }),
    buttonColor: "danger",
    cancelButtonText: _constants.CANCEL_BUTTON_LABEL,
    confirmButtonText: _constants.DELETE_BUTTON_LABEL,
    defaultFocusedButton: "confirm",
    maxWidth: true,
    "aria-labelledby": confirmModalTitleId,
    titleProps: {
      id: confirmModalTitleId
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.deleteConfirm.description', {
    defaultMessage: 'You are removing the pipeline "{pipelineName}" from the Machine Learning Inference Pipeline and deleting it.',
    values: {
      pipelineName
    }
  })))));
};
exports.TrainedModelHealthPopover = TrainedModelHealthPopover;
const InferencePipelineCard = pipeline => {
  const {
    modelId,
    pipelineName,
    types: modelTypes
  } = pipeline;
  const modelIdDisplay = modelId && modelId.length > 0 ? modelId : _utils2.MODEL_REDACTED_VALUE;
  const modelType = (0, _utils.getMLType)(modelTypes);
  const modelTitle = (0, _utils.getModelDisplayTitle)(modelType);
  const isSmallScreen = (0, _eui.useIsWithinMaxBreakpoint)('s');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: isSmallScreen ? 'xs' : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 17
    }
  }, pipelineName !== null && pipelineName !== void 0 ? pipelineName : modelTitle))), modelTitle && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 21
    }
  }, modelIdDisplay)), modelId && modelId.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_ml_model_type_badge.MLModelTypeBadge, {
    type: modelType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 25
    }
  }))))), pipeline.sourceFields && pipeline.sourceFields.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 17
    }
  }, pipeline.sourceFields.join(', '))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(TrainedModelHealthPopover, (0, _extends2.default)({}, pipeline, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 11
    }
  })))));
};
exports.InferencePipelineCard = InferencePipelineCard;