"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewConnectorTemplate = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../common/constants");
var _beta_connector_callout = require("../../../../shared/beta/beta_connector_callout");
var _constants2 = require("../../../../shared/constants");
var _doc_links = require("../../../../shared/doc_links");
var _new_connector_logic = require("./new_connector_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/new_index/method_connector/new_connector_template.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NewConnectorTemplate = ({
  buttonLoading,
  disabled,
  error,
  onNameChange,
  onSubmit,
  type,
  isBeta
}) => {
  const {
    connectorName,
    rawName
  } = (0, _kea.useValues)(_new_connector_logic.NewConnectorLogic);
  const {
    setRawName
  } = (0, _kea.useActions)(_new_connector_logic.NewConnectorLogic);
  const handleNameChange = e => {
    setRawName(e.target.value);
    if (onNameChange) {
      onNameChange(connectorName);
    }
  };
  const formInvalid = !!error;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    id: "enterprise-search-create-connector",
    onSubmit: event => {
      event.preventDefault();
      onSubmit(connectorName);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, isBeta ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_beta_connector_callout.BetaConnectorCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 15
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.newConnector.newConnectorTemplate.formTitle",
    defaultMessage: "Create a connector",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isDisabled: disabled || buttonLoading,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.newConnector.newConnectorTemplate.nameInputLabel', {
      defaultMessage: 'Connector name'
    }),
    isInvalid: formInvalid,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "enterpriseSearchNewConnectorTemplateFieldText",
    "data-telemetry-id": `entSearchContent-${type}-newConnector-editName`,
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.content.newConnector.newConnectorTemplate.nameInputPlaceholder', {
      defaultMessage: 'Set a name for your connector'
    }),
    fullWidth: true,
    disabled: disabled,
    isInvalid: formInvalid,
    value: rawName,
    onChange: handleNameChange,
    autoFocus: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.newConnector.newConnectorTemplate.nameInputHelpText.lineTwo', {
    defaultMessage: 'Names should be lowercase and cannot contain spaces or special characters.'
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }, type === _constants.INGESTION_METHOD_IDS.CONNECTOR && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "enterpriseSearchNewConnectorTemplateLearnMoreAboutConnectorsLink",
    target: "_blank",
    href: _doc_links.docLinks.connectors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.newConnector.newConnectorTemplate.learnMoreConnectors.linkText', {
    defaultMessage: 'Learn more about connectors'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchNewConnectorTemplateButton",
    "data-telemetry-id": `entSearchContent-${type}-newConnector-goBack`,
    isDisabled: buttonLoading,
    onClick: () => history.back(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 13
    }
  }, _constants2.BACK_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": `entSearchContent-${type}-newConnector-createConnector`,
    "data-telemetry-id": `entSearchContent-${type}-newConnector-createConnector`,
    fill: true,
    isDisabled: !rawName || buttonLoading || formInvalid || disabled,
    isLoading: buttonLoading,
    type: "submit",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.newConnector.newConnectorTemplate.createIndex.buttonText', {
    defaultMessage: 'Create connector'
  }))))));
};
exports.NewConnectorTemplate = NewConnectorTemplate;