"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _stats_table = require("../../../common/components/stats_table");
var _use_data_visualizer_esql_data = require("../../hooks/esql/use_data_visualizer_esql_data");
var _embeddable_field_stats_no_results = require("./embeddable_field_stats_no_results");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/index_data_visualizer/embeddables/grid_embeddable/embeddable_esql_field_stats_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const restorableDefaults = (0, _use_data_visualizer_esql_data.getDefaultESQLDataVisualizerListState)();
const EmbeddableESQLFieldStatsTableWrapper = /*#__PURE__*/_react.default.memo(props => {
  const {
    onTableUpdate,
    onRenderComplete
  } = props;
  const [dataVisualizerListState, setDataVisualizerListState] = (0, _react.useState)(restorableDefaults);
  const onTableChange = (0, _react.useCallback)(update => {
    setDataVisualizerListState({
      ...dataVisualizerListState,
      ...update
    });
    if (onTableUpdate) {
      onTableUpdate(update);
    }
  }, [dataVisualizerListState, onTableUpdate]);
  const {
    configs,
    extendedColumns,
    progress,
    overallStatsProgress,
    setLastRefresh,
    getItemIdToExpandedRowMap,
    resetData
  } = (0, _use_data_visualizer_esql_data.useESQLDataVisualizerData)(props, dataVisualizerListState);
  (0, _react.useEffect)(() => {
    setLastRefresh(Date.now());
  }, [props === null || props === void 0 ? void 0 : props.lastReloadRequestTime, setLastRefresh]);
  (0, _react.useEffect)(() => {
    var _props$resetData$;
    const subscription = (_props$resetData$ = props.resetData$) === null || _props$resetData$ === void 0 ? void 0 : _props$resetData$.subscribe(() => {
      resetData();
    });
    return () => subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
  }, [props.resetData$, resetData]);
  (0, _react.useEffect)(() => {
    if (progress === 100 && onRenderComplete) {
      onRenderComplete();
    }
  }, [progress, onRenderComplete]);
  if (progress === 100 && configs.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_embeddable_field_stats_no_results.EmbeddableNoResultsEmptyPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 14
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_stats_table.DataVisualizerTable, {
    isEsql: true,
    items: configs,
    pageState: dataVisualizerListState,
    updatePageState: onTableChange,
    getItemIdToExpandedRowMap: getItemIdToExpandedRowMap,
    extendedColumns: extendedColumns,
    showPreviewByDefault: props === null || props === void 0 ? void 0 : props.showPreviewByDefault,
    onChange: onTableUpdate,
    loading: progress < 100,
    overallStatsRunning: overallStatsProgress.isRunning,
    error: overallStatsProgress.error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  });
});
// exporting as default so it be lazy-loaded
// eslint-disable-next-line import/no-default-export
var _default = exports.default = EmbeddableESQLFieldStatsTableWrapper;
module.exports = exports.default;