"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PopoverActionsMenu = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../types");
var _get_action = require("./get_action");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/data/public/search/session/sessions_mgmt/components/table/actions/popover_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PopoverActionsMenu = ({
  api,
  onActionComplete,
  session,
  core,
  allowedActions
}) => {
  var _session$actions;
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const onPopoverClick = () => {
    setPopover(!isPopoverOpen);
  };
  const closePopover = () => {
    setPopover(false);
  };
  const renderPopoverButton = () => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('data.mgmt.searchSessions.actions.tooltip.moreActions', {
      defaultMessage: 'More actions'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('data.mgmt.searchSessions.ariaLabel.moreActions', {
      defaultMessage: 'More actions'
    }),
    color: "text",
    iconType: "boxesHorizontal",
    onClick: onPopoverClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }));
  const actions = ((_session$actions = session.actions) === null || _session$actions === void 0 ? void 0 : _session$actions.filter(action => {
    if (!allowedActions) return true;
    return allowedActions.includes(action);
  })) || [];
  // Generic set of actions - up to the API to return what is available
  const items = actions.reduce((itemSet, actionType) => {
    const actionDef = (0, _get_action.getAction)(api, actionType, session, core);
    if (actionDef) {
      const {
        label,
        iconType,
        onClick
      } = actionDef;

      // add a line above the delete action (when there are multiple)
      // NOTE: Delete action MUST be the final action[] item
      if (actions.length > 1 && actionType === _types.ACTION.DELETE) {
        itemSet.push({
          isSeparator: true,
          key: 'separadorable'
        });
      }
      return [...itemSet, {
        key: `action-${actionType}`,
        name: label,
        icon: iconType,
        'data-test-subj': `sessionManagementPopoverAction-${actionType}`,
        onClick: async () => {
          closePopover();
          await onClick();
          onActionComplete();
        }
      }];
    }
    return itemSet;
  }, []);
  const panels = [{
    id: 0,
    items
  }];
  return actions.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: `popover-${session.id}`,
    button: renderPopoverButton(),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "downLeft",
    panelPaddingSize: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  })) : null;
};
exports.PopoverActionsMenu = PopoverActionsMenu;