"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoFollowPatternAdd = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _breadcrumbs = require("../../services/breadcrumbs");
var _components = require("../../components");
var _shared_imports = require("../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/cross_cluster_replication/public/app/sections/auto_follow_pattern_add/auto_follow_pattern_add.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class AutoFollowPatternAdd extends _react.PureComponent {
  componentDidMount() {
    (0, _breadcrumbs.setBreadcrumbs)([(0, _breadcrumbs.listBreadcrumb)('/auto_follow_patterns'), _breadcrumbs.addBreadcrumb]);
  }
  componentWillUnmount() {
    this.props.clearApiError();
  }
  render() {
    const {
      saveAutoFollowPattern,
      apiStatus,
      apiError,
      match: {
        url: currentUrl
      }
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_components.RemoteClustersProvider, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 7
      }
    }, ({
      isLoading,
      error,
      remoteClusters
    }) => {
      if (isLoading) {
        return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 50,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.autoFollowPatternCreateForm.loadingRemoteClustersMessage",
          defaultMessage: "Loading remote clusters\u2026",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 51,
            columnNumber: 17
          }
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
        restrictWidth: true,
        style: {
          width: '100%'
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_components.AutoFollowPatternPageTitle, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.autoFollowPattern.addTitle",
          defaultMessage: "Add auto-follow pattern",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 63,
            columnNumber: 19
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 61,
          columnNumber: 15
        }
      }), /*#__PURE__*/_react.default.createElement(_components.AutoFollowPatternForm, {
        apiStatus: apiStatus,
        apiError: apiError,
        currentUrl: currentUrl,
        remoteClusters: error ? [] : remoteClusters,
        saveAutoFollowPattern: saveAutoFollowPattern,
        saveButtonLabel: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.autoFollowPatternCreateForm.saveButtonLabel",
          defaultMessage: "Create",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 77,
            columnNumber: 19
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 15
        }
      }));
    });
  }
}
exports.AutoFollowPatternAdd = AutoFollowPatternAdd;
(0, _defineProperty2.default)(AutoFollowPatternAdd, "propTypes", {
  saveAutoFollowPattern: _propTypes.default.func.isRequired,
  clearApiError: _propTypes.default.func.isRequired,
  apiError: _propTypes.default.object,
  apiStatus: _propTypes.default.string.isRequired
});