"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppMenuBar = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _header_action_menu = require("../header/header_action_menu");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/core/packages/chrome/browser-internal/src/ui/project/app_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useAppMenuBarStyles = euiTheme => (0, _react.useMemo)(() => {
  const zIndex = typeof euiTheme.levels.header === 'number' ? euiTheme.levels.header - 10 // Appear right below the header
  : euiTheme.levels.header;

  // Root bar styles
  const root = {
    display: 'flex',
    justifyContent: 'end',
    alignItems: 'center',
    padding: `0 ${euiTheme.size.s}`,
    background: euiTheme.colors.body,
    borderBottom: euiTheme.border.thin,
    marginBottom: `-${euiTheme.border.width.thin}`
  };
  // Styles for fixed (sticky) mode
  const fixed = {
    zIndex,
    position: 'sticky',
    // Fixates the element in the viewport
    top: 'var(--euiFixedHeadersOffset, 0)',
    // Below primary fixed EuiHeader
    height: `var(--kbnProjectHeaderAppActionMenuHeight, ${euiTheme.size.xxxl})`
  };
  // Styles for static mode
  const staticStyle = {
    height: '100%'
  };
  return {
    root,
    fixed,
    static: staticStyle
  };
}, [euiTheme]);
const AppMenuBar = ({
  appMenuActions$,
  isFixed = true
}) => {
  const headerActionMenuMounter = (0, _header_action_menu.useHeaderActionMenuMounter)(appMenuActions$);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = useAppMenuBarStyles(euiTheme);
  if (!headerActionMenuMounter.mount) return null;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "header__actionMenu",
    "data-test-subj": "kibanaProjectHeaderActionMenu",
    css: [styles.root, isFixed ? styles.fixed : styles.static],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_header_action_menu.HeaderActionMenu, {
    mounter: headerActionMenuMounter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }));
};
exports.AppMenuBar = AppMenuBar;