"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPostureScorePercentage = exports.ComplianceScoreChart = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _test_subjects = require("../test_subjects");
var _constants = require("../../../../common/constants");
var _compact_formatted_number = require("../../../components/compact_formatted_number");
var _use_kibana = require("../../../common/hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/compliance_dashboard/compliance_charts/compliance_score_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CounterButtonLink = ({
  text,
  count,
  color,
  'data-test-subj': dataTestSubj,
  onClick
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: {
      fontWeight: euiTheme.font.weight.bold,
      marginBottom: euiTheme.size.xs
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, text), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    color: "text",
    onClick: onClick,
    "data-test-subj": dataTestSubj,
    css: (0, _react2.css)`
          display: flex;
          &:hover {
            text-decoration: none;
          }
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: color,
    css: (0, _react2.css)`
            font-weight: ${euiTheme.font.weight.medium};
            font-size: 18px;

            &:hover {
              border-bottom: 2px solid ${color};
              padding-bottom: 4px;
            }
          `,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_compact_formatted_number.CompactFormattedNumber, {
    number: count,
    abbreviateAbove: 999,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }), "\xA0")));
};
const CompactPercentageLabels = ({
  onEvalCounterClick,
  stats
}) => {
  const {
    getMisconfigurationStatusColor
  } = (0, _cloudSecurityPosture.useGetMisconfigurationStatusColor)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(CounterLink, {
    text: "passed",
    count: stats.totalPassed,
    color: getMisconfigurationStatusColor(_cloudSecurityPostureCommon.MISCONFIGURATION_STATUS.PASSED),
    onClick: () => onEvalCounterClick(_constants.RULE_PASSED),
    tooltipContent: _i18n.i18n.translate('xpack.csp.complianceScoreChart.counterLink.passedFindingsTooltip', {
      defaultMessage: 'Passed findings'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }, "\xA0-\xA0"), /*#__PURE__*/_react.default.createElement(CounterLink, {
    text: "failed",
    count: stats.totalFailed,
    color: getMisconfigurationStatusColor(_cloudSecurityPostureCommon.MISCONFIGURATION_STATUS.FAILED),
    onClick: () => onEvalCounterClick(_constants.RULE_FAILED),
    tooltipContent: _i18n.i18n.translate('xpack.csp.complianceScoreChart.counterButtonLink.failedFindingsTooltip', {
      defaultMessage: 'Failed findings'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }));
};
const PercentageLabels = ({
  onEvalCounterClick,
  stats
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    getMisconfigurationStatusColor
  } = (0, _cloudSecurityPosture.useGetMisconfigurationStatusColor)();
  const borderLeftStyles = {
    borderLeft: euiTheme.border.thin,
    paddingLeft: euiTheme.size.m
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: borderLeftStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(CounterButtonLink, {
    text: "Passed Findings",
    count: stats.totalPassed,
    color: getMisconfigurationStatusColor(_cloudSecurityPostureCommon.MISCONFIGURATION_STATUS.PASSED),
    "data-test-subj": "dashboard-summary-passed-findings",
    onClick: () => onEvalCounterClick(_constants.RULE_PASSED),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: borderLeftStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(CounterButtonLink, {
    text: "Failed Findings",
    count: stats.totalFailed,
    color: getMisconfigurationStatusColor(_cloudSecurityPostureCommon.MISCONFIGURATION_STATUS.FAILED),
    "data-test-subj": "dashboard-summary-failed-findings",
    onClick: () => onEvalCounterClick(_constants.RULE_FAILED),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 9
    }
  })));
};
const getPostureScorePercentage = postureScore => `${Math.round(postureScore)}%`;
exports.getPostureScorePercentage = getPostureScorePercentage;
const PercentageInfo = ({
  compact,
  postureScore
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const percentage = getPostureScorePercentage(postureScore);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    css: {
      fontSize: compact ? euiTheme.size.l : euiTheme.size.xxl,
      paddingLeft: compact ? euiTheme.size.s : euiTheme.size.xs,
      marginBottom: compact ? euiTheme.size.s : 'none'
    },
    "data-test-subj": _test_subjects.DASHBOARD_COMPLIANCE_SCORE_CHART.COMPLIANCE_SCORE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 7
    }
  }, percentage));
};
const convertTrendToEpochTime = trend => ({
  ...trend,
  timestamp: (0, _moment.default)(trend.timestamp).valueOf()
});
const ComplianceTrendChart = ({
  trend
}) => {
  const epochTimeTrend = trend.map(convertTrendToEpochTime);
  const {
    services: {
      charts
    }
  } = (0, _use_kibana.useKibana)();
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    headerFormatter: ({
      value
    }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
      value: value,
      month: "short",
      day: "numeric",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 13
      }
    }), ', ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedTime, {
      value: value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: charts.theme.useChartsBaseTheme(),
    showLegend: false,
    legendPosition: "right",
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.AreaSeries
  // EuiChart is using this id in the tooltip label
  , {
    id: "Posture Score",
    data: epochTimeTrend
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    xAccessor: 'timestamp',
    yAccessors: ['postureScore'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom-axis",
    position: "bottom",
    tickFormat: (0, _charts.timeFormatter)((0, _charts.niceTimeFormatByDay)(2)),
    ticks: 4,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    ticks: 3,
    id: "left-axis",
    position: "left",
    gridLine: {
      visible: true
    },
    domain: {
      min: 0,
      max: 100
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 7
    }
  }));
};
const CounterLink = ({
  text,
  count,
  color,
  onClick,
  tooltipContent
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltipContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": `compliance-score-section-${text}`,
    color: "text",
    onClick: onClick,
    css: {
      display: 'flex'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: color,
    css: {
      fontWeight: euiTheme.font.weight.medium
    },
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_compact_formatted_number.CompactFormattedNumber, {
    number: count,
    abbreviateAbove: 999,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 11
    }
  }), "\xA0"), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 9
    }
  }, text)));
};
const ComplianceScoreChart = ({
  data,
  trend,
  onEvalCounterClick,
  compact
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "spaceBetween",
    css: {
      height: '100%'
    },
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(PercentageInfo, (0, _extends2.default)({}, data, {
    compact: compact,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "none",
    alignItems: "flexStart",
    css: {
      paddingRight: euiTheme.size.xl
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 13
    }
  }, compact ? /*#__PURE__*/_react.default.createElement(CompactPercentageLabels, {
    stats: {
      totalPassed: data.totalPassed,
      totalFailed: data.totalFailed
    },
    onEvalCounterClick: onEvalCounterClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(PercentageLabels, {
    stats: {
      totalPassed: data.totalPassed,
      totalFailed: data.totalFailed
    },
    onEvalCounterClick: onEvalCounterClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(ComplianceTrendChart, {
    trend: trend,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 9
    }
  })));
};
exports.ComplianceScoreChart = ComplianceScoreChart;