"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditableTitle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _constants = require("../../../common/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _title = require("./title");
var _use_cases_context = require("../cases_context/use_cases_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cases/public/components/header_page/editable_title.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditableTitleComponent = ({
  onSubmit,
  isLoading,
  title
}) => {
  const {
    releasePhase,
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const [editMode, setEditMode] = (0, _react.useState)(false);
  const [errors, setErrors] = (0, _react.useState)([]);
  const onClickSubmit = (0, _react.useCallback)(newTitleValue => {
    if (!newTitleValue.trim().length) {
      setErrors([i18n.TITLE_REQUIRED]);
      return false;
    }
    if (newTitleValue.trim().length > _constants.MAX_TITLE_LENGTH) {
      setErrors([i18n.MAX_LENGTH_ERROR('title', _constants.MAX_TITLE_LENGTH)]);
      return false;
    }
    if (newTitleValue !== title) {
      onSubmit(newTitleValue.trim());
    }
    setEditMode(false);
    setErrors([]);
    return true;
  }, [onSubmit, title]);
  const onCancel = () => {
    setErrors([]);
    setEditMode(false);
  };
  const hasErrors = errors.length > 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: releasePhase && (0, _react2.css)`
            overflow: hidden;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInlineEditTitle, {
    defaultValue: title,
    readModeProps: {
      onClick: () => setEditMode(true),
      'data-test-subj': 'editable-title-header-value'
    },
    editModeProps: {
      formRowProps: {
        error: errors
      },
      inputProps: {
        'data-test-subj': 'editable-title-input-field',
        onChange: () => {
          setErrors([]);
        }
      },
      saveButtonProps: {
        'data-test-subj': 'editable-title-submit-btn',
        isDisabled: hasErrors
      },
      cancelButtonProps: {
        onClick: () => onCancel(),
        'data-test-subj': 'editable-title-cancel-btn'
      }
    },
    inputAriaLabel: "Editable title input field",
    heading: "h1",
    size: "s",
    isInvalid: hasErrors,
    isLoading: isLoading,
    isReadOnly: !permissions.update,
    onSave: value => {
      return onClickSubmit(value);
    },
    startWithEditOpen: editMode,
    "data-test-subj": "header-page-title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, releasePhase === 'experimental' && /*#__PURE__*/_react.default.createElement(_title.TitleExperimentalBadge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 45
    }
  }), releasePhase === 'beta' && /*#__PURE__*/_react.default.createElement(_title.TitleBetaBadge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 37
    }
  })));
};
EditableTitleComponent.displayName = 'EditableTitle';
const EditableTitle = exports.EditableTitle = /*#__PURE__*/_react.default.memo(EditableTitleComponent);