"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StorageDetailsPerService = StorageDetailsPerService;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _common = require("@kbn/observability-plugin/common");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_time_range = require("../../../../hooks/use_time_range");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_progressive_fetcher = require("../../../../hooks/use_progressive_fetcher");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _formatters = require("../../../../../common/utils/formatters/formatters");
var _i18n2 = require("../../../../../common/i18n");
var _formatters2 = require("../../../../../common/utils/formatters");
var _get_comparison_enabled = require("../../../shared/time_comparison/get_comparison_enabled");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _size_label = require("./size_label");
var _index_stats_per_service = require("./index_stats_per_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/storage_explorer/services_table/storage_details_per_service.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ProcessorEventLabelMap = {
  [_common.ProcessorEvent.transaction]: _i18n.i18n.translate('xpack.apm.storageExplorer.serviceDetails.transactions', {
    defaultMessage: 'Transactions'
  }),
  [_common.ProcessorEvent.span]: _i18n.i18n.translate('xpack.apm.storageExplorer.serviceDetails.spans', {
    defaultMessage: 'Spans'
  }),
  [_common.ProcessorEvent.metric]: _i18n.i18n.translate('xpack.apm.storageExplorer.serviceDetails.metrics', {
    defaultMessage: 'Metrics'
  }),
  [_common.ProcessorEvent.error]: _i18n.i18n.translate('xpack.apm.storageExplorer.serviceDetails.errors', {
    defaultMessage: 'Errors'
  })
};
function StorageDetailsPerService({
  serviceName,
  indexLifecyclePhase
}) {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const chartThemes = (0, _public.useChartThemes)();
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/storage-explorer');
  const {
    rangeFrom,
    rangeTo,
    environment,
    kuery,
    comparisonEnabled: urlComparisonEnabled
  } = query;
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const serviceOverviewLink = router.link('/services/{serviceName}/overview', {
    path: {
      serviceName
    },
    query: {
      ...query,
      serviceGroup: '',
      comparisonEnabled: (0, _get_comparison_enabled.getComparisonEnabled)({
        core,
        urlComparisonEnabled
      })
    }
  });
  const groupedPalette = (0, _eui.euiPaletteColorBlind)();
  const {
    data,
    status
  } = (0, _use_progressive_fetcher.useProgressiveFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/services/{serviceName}/storage_details', {
      params: {
        path: {
          serviceName
        },
        query: {
          indexLifecyclePhase,
          start,
          end,
          environment,
          kuery
        }
      }
    });
  }, [indexLifecyclePhase, start, end, environment, kuery, serviceName]);
  if ((0, _use_fetcher.isPending)(status)) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '50%'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      "data-test-subj": "loadingSpinner",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 9
      }
    }));
  }
  if (!data || !data.processorEventStats) {
    return null;
  }
  const processorEventStats = data.processorEventStats.map(({
    processorEvent,
    docs,
    size
  }) => ({
    processorEventLabel: ProcessorEventLabelMap[processorEvent],
    docs,
    size
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    gutterSize: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.apm.storageExplorer.serviceDetails.title', {
    defaultMessage: 'Service storage details'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmStorageDetailsPerServiceGoToServiceOverviewLink",
    href: serviceOverviewLink,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.storageExplorer.serviceDetails.serviceOverviewLink', {
    defaultMessage: 'Go to service overview'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    "data-test-subj": "serviceStorageDetailsChart",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: [{
      partition: {
        fillLabel: {
          textColor: euiTheme.colors.emptyShade
        },
        emptySizeRatio: 0.3
      }
    }, ...chartThemes.theme],
    baseTheme: chartThemes.baseTheme,
    locale: _i18n.i18n.getLocale(),
    showLegend: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Partition, {
    layout: _charts.PartitionLayout.sunburst,
    id: "storageExplorerSizeByProcessorType",
    data: processorEventStats,
    valueAccessor: d => {
      var _d$size;
      return (_d$size = d.size) !== null && _d$size !== void 0 ? _d$size : 0;
    },
    valueGetter: "percent",
    valueFormatter: d => (0, _formatters2.asDynamicBytes)(d) || _i18n2.NOT_AVAILABLE_LABEL,
    layers: [{
      groupByRollup: d => d.processorEventLabel,
      shape: {
        fillColor: (dataName, sortIndex) => groupedPalette[sortIndex]
      }
    }],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "l",
    "data-test-subj": "serviceStorageDetailsTable",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 15
    }
  }, processorEventStats.map(({
    processorEventLabel,
    docs,
    size
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    css: (0, _react2.css)`
                        font-weight: ${euiTheme.font.weight.semiBold};
                      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 23
    }
  }, processorEventLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_size_label.SizeLabel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 25
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    css: (0, _react2.css)`
                        background-color: ${euiTheme.colors.lightestShade};
                        border-top: 1px solid ${euiTheme.colors.lightShade};
                        border-bottom: 1px solid ${euiTheme.colors.lightShade};
                      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 23
    }
  }, (0, _formatters.asInteger)(docs)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 23
    }
  }, (0, _formatters2.asDynamicBytes)(size))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 21
    }
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_index_stats_per_service.IndexStatsPerService, {
    indicesStats: data.indicesStats,
    status: status,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 11
    }
  }))));
}