"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedConfiguration = AdvancedConfiguration;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _advanced_config_key_input = require("./advanced_config_key_input");
var _advanced_config_value_input = require("./advanced_config_value_input");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/agent_configurations/agent_configuration_create_edit/settings_page/advanced_configuration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AdvancedConfiguration({
  newConfig,
  settingsDefinitions,
  revalidate,
  onChange,
  onDelete,
  addNewRow,
  addValidationError,
  removeValidationError
}) {
  var _newConfig$agent_name;
  const agentLanguage = ((_newConfig$agent_name = newConfig.agent_name) === null || _newConfig$agent_name === void 0 ? void 0 : _newConfig$agent_name.split('/')[1]) || '';
  const predefinedAgentConfigKeys = (0, _react.useMemo)(() => new Set(settingsDefinitions.map(setting => setting.key)), [settingsDefinitions]);
  const unknownAgentConfigs = (0, _react.useMemo)(() => {
    return new Map(Object.entries(newConfig.settings).filter(([key]) => !predefinedAgentConfigKeys.has(key)));
  }, [predefinedAgentConfigKeys, newConfig.settings]);

  // Validations
  const checkIfAdvancedConfigKeyExists = (0, _react.useCallback)(key => unknownAgentConfigs.has(key), [unknownAgentConfigs]);
  const checkIfPredefinedConfigKeyExists = (0, _react.useCallback)(key => predefinedAgentConfigKeys.has(key), [predefinedAgentConfigKeys]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.agentConfig.settingsPage.advancedConfigurationTitle",
    defaultMessage: "Advanced Configuration",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.agentConfig.settingsPage.advancedConfigurationDescription",
    defaultMessage: "Advanced configuration allows you to define custom settings that are not covered by the standard predefined options above. These settings are passed directly to your EDOT SDK. Use with caution as incorrect configuration may affect your SDK's behavior.",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 15
    }
  }))), agentLanguage && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmAdvancedConfigurationDocumentationLink",
    href: `https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/${agentLanguage}/configuration`,
    target: "_blank",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.agentConfig.settingsPage.advancedConfigurationLearnMore",
    defaultMessage: "Learn more about configuration options",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "rowReverse",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmSettingsAddAdvancedConfigurationButton",
    iconType: "plusInCircle",
    onClick: addNewRow,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.settingsPage.addCustomSettingButton', {
    defaultMessage: 'Add custom setting'
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }), [...unknownAgentConfigs].map(([configKey, configValue], index) =>
  /*#__PURE__*/
  // Use reverse index as key prop to allow adding new rows at the top
  _react.default.createElement(_react.Fragment, {
    key: unknownAgentConfigs.size - 1 - index,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }, index > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 25
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_advanced_config_key_input.AdvancedConfigKeyInput, {
    configKey: configKey,
    id: index,
    showLabel: index === 0,
    revalidate: revalidate,
    onChange: onChange,
    checkIfAdvancedConfigKeyExists: checkIfAdvancedConfigKeyExists,
    checkIfPredefinedConfigKeyExists: checkIfPredefinedConfigKeyExists,
    addValidationError: addValidationError,
    removeValidationError: removeValidationError,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_advanced_config_value_input.AdvancedConfigValueInput, {
    configValue: configValue,
    configKey: configKey,
    id: index,
    showLabel: index === 0,
    revalidate: revalidate,
    onChange: onChange,
    onDelete: onDelete,
    addValidationError: addValidationError,
    removeValidationError: removeValidationError,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 7
    }
  }));
}