"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveGroupModal = SaveGroupModal;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _react = _interopRequireWildcard(require("react"));
var _create_call_apm_api = require("../../../../services/rest/create_call_apm_api");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _group_details = require("./group_details");
var _select_services = require("./select_services");
var _refresh_service_groups_subscriber = require("../refresh_service_groups_subscriber");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_groups/service_group_save/save_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SaveGroupModal({
  onClose,
  savedServiceGroup
}) {
  const {
    core: {
      notifications
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const [modalView, setModalView] = (0, _react.useState)('group_details');
  const [stagedServiceGroup, setStagedServiceGroup] = (0, _react.useState)(savedServiceGroup);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    setStagedServiceGroup(savedServiceGroup);
  }, [savedServiceGroup]);
  const isEdit = !!savedServiceGroup;
  const history = (0, _reactRouterDom.useHistory)();
  const navigateToServiceGroups = (0, _react.useCallback)(() => {
    history.push({
      ...history.location,
      pathname: '/service-groups',
      search: ''
    });
  }, [history]);
  const onSave = (0, _react.useCallback)(async function (newServiceGroup) {
    setIsLoading(true);
    try {
      await (0, _create_call_apm_api.callApmApi)('POST /internal/apm/service-group', {
        params: {
          query: {
            serviceGroupId: savedServiceGroup === null || savedServiceGroup === void 0 ? void 0 : savedServiceGroup.id
          },
          body: {
            groupName: newServiceGroup.groupName,
            kuery: newServiceGroup.kuery,
            description: newServiceGroup.description,
            color: newServiceGroup.color
          }
        },
        signal: null
      });
      notifications.toasts.addSuccess(isEdit ? getEditSuccessToastLabels(newServiceGroup) : getCreateSuccessToastLabels(newServiceGroup));
      (0, _refresh_service_groups_subscriber.refreshServiceGroups)();
      navigateToServiceGroups();
    } catch (error) {
      console.error(error);
      notifications.toasts.addDanger(isEdit ? getEditFailureToastLabels(newServiceGroup, error) : getCreateFailureToastLabels(newServiceGroup, error));
    }
    onClose();
    setIsLoading(false);
  }, [savedServiceGroup === null || savedServiceGroup === void 0 ? void 0 : savedServiceGroup.id, notifications.toasts, onClose, isEdit, navigateToServiceGroups]);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const onDelete = (0, _react.useCallback)(async function () {
    setIsLoading(true);
    if (!savedServiceGroup) {
      notifications.toasts.addDanger(getDeleteFailureUnknownIdToastLabels(stagedServiceGroup));
      return;
    }
    try {
      await (0, _create_call_apm_api.callApmApi)('DELETE /internal/apm/service-group', {
        params: {
          query: {
            serviceGroupId: savedServiceGroup.id
          }
        },
        signal: null
      });
      notifications.toasts.addSuccess(getDeleteSuccessToastLabels(stagedServiceGroup));
      (0, _refresh_service_groups_subscriber.refreshServiceGroups)();
      navigateToServiceGroups();
    } catch (error) {
      console.error(error);
      notifications.toasts.addDanger(getDeleteFailureToastLabels(stagedServiceGroup, error));
    }
    onClose();
    setIsLoading(false);
  }, [stagedServiceGroup, notifications.toasts, onClose, navigateToServiceGroups, savedServiceGroup]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    "aria-labelledby": modalTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  }, modalView === 'group_details' && /*#__PURE__*/_react.default.createElement(_group_details.GroupDetails, {
    serviceGroup: stagedServiceGroup,
    isEdit: isEdit,
    onCloseModal: onClose,
    onClickNext: _serviceGroup => {
      setStagedServiceGroup(_serviceGroup);
      setModalView('select_service');
    },
    onDeleteGroup: onDelete,
    isLoading: isLoading,
    titleId: modalTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }), modalView === 'select_service' && stagedServiceGroup && /*#__PURE__*/_react.default.createElement(_select_services.SelectServices, {
    serviceGroup: stagedServiceGroup,
    isEdit: isEdit,
    onCloseModal: onClose,
    onSaveClick: onSave,
    onEditGroupDetailsClick: () => {
      setModalView('group_details');
    },
    isLoading: isLoading,
    titleId: modalTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }));
}
function getCreateSuccessToastLabels({
  groupName
}) {
  return {
    title: _i18n.i18n.translate('xpack.apm.serviceGroups.createSucess.toast.title', {
      defaultMessage: 'Created "{groupName}" group',
      values: {
        groupName
      }
    }),
    text: _i18n.i18n.translate('xpack.apm.serviceGroups.createSuccess.toast.text', {
      defaultMessage: 'Your group is now visible in the new Services view for groups.'
    })
  };
}
function getEditSuccessToastLabels({
  groupName
}) {
  return {
    title: _i18n.i18n.translate('xpack.apm.serviceGroups.editSucess.toast.title', {
      defaultMessage: 'Edited "{groupName}" group',
      values: {
        groupName
      }
    }),
    text: _i18n.i18n.translate('xpack.apm.serviceGroups.editSuccess.toast.text', {
      defaultMessage: 'Saved new changes to service group.'
    })
  };
}
function getCreateFailureToastLabels({
  groupName
}, error) {
  return {
    title: _i18n.i18n.translate('xpack.apm.serviceGroups.createFailure.toast.title', {
      defaultMessage: 'Error while creating "{groupName}" group',
      values: {
        groupName
      }
    }),
    text: error.body.message
  };
}
function getEditFailureToastLabels({
  groupName
}, error) {
  return {
    title: _i18n.i18n.translate('xpack.apm.serviceGroups.editFailure.toast.title', {
      defaultMessage: 'Error while editing "{groupName}" group',
      values: {
        groupName
      }
    }),
    text: error.body.message
  };
}
function getDeleteSuccessToastLabels({
  groupName
}) {
  return {
    title: _i18n.i18n.translate('xpack.apm.serviceGroups.deleteSuccess.toast.title', {
      defaultMessage: 'Deleted "{groupName}" group',
      values: {
        groupName
      }
    })
  };
}
function getDeleteFailureUnknownIdToastLabels({
  groupName
}) {
  return {
    title: _i18n.i18n.translate('xpack.apm.serviceGroups.deleteFailure.unknownId.toast.title', {
      defaultMessage: 'Error while deleting "{groupName}" group',
      values: {
        groupName
      }
    }),
    text: _i18n.i18n.translate('xpack.apm.serviceGroups.deleteFailure.unknownId.toast.text', {
      defaultMessage: 'Unable to delete group: unknown service group id.'
    })
  };
}
function getDeleteFailureToastLabels({
  groupName
}, error) {
  return {
    title: _i18n.i18n.translate('xpack.apm.serviceGroups.deleteFailure.toast.title', {
      defaultMessage: 'Error while deleting "{groupName}" group',
      values: {
        groupName
      }
    }),
    text: error.body.message
  };
}