"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HttpErrorRateChart = HttpErrorRateChart;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _get_comparison_chart_theme = require("../../../../shared/time_comparison/get_comparison_chart_theme");
var _timeseries_chart_with_context = require("../../../../shared/charts/timeseries_chart_with_context");
var _use_fetcher = require("../../../../../hooks/use_fetcher");
var _get_timeseries_color = require("../../../../shared/charts/helper/get_timeseries_color");
var _use_previous_period_text = require("../../../../../hooks/use_previous_period_text");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/charts/mobile_http_error_rate/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const INITIAL_STATE = {
  currentPeriod: {
    timeseries: []
  },
  previousPeriod: {
    timeseries: []
  }
};
function HttpErrorRateChart({
  height,
  kuery,
  serviceName,
  start,
  end,
  environment,
  offset,
  comparisonEnabled
}) {
  const comparisonChartTheme = (0, _get_comparison_chart_theme.getComparisonChartTheme)();
  const {
    currentPeriodColor,
    previousPeriodColor
  } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.HTTP_REQUESTS);
  const {
    data = INITIAL_STATE,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/mobile-services/{serviceName}/error/http_error_rate', {
      params: {
        path: {
          serviceName
        },
        query: {
          environment,
          kuery,
          start,
          end,
          offset: comparisonEnabled ? offset : undefined
        }
      }
    });
  }, [environment, kuery, serviceName, start, end, offset, comparisonEnabled]);
  const previousPeriodLabel = (0, _use_previous_period_text.usePreviousPeriodLabel)();
  const timeseries = [{
    data: data.currentPeriod.timeseries,
    type: 'linemark',
    color: currentPeriodColor,
    title: _i18n.i18n.translate('xpack.apm.errors.httpErrorRateTitle', {
      defaultMessage: 'HTTP error rate'
    })
  }, ...(comparisonEnabled ? [{
    data: data.previousPeriod.timeseries,
    type: 'area',
    color: previousPeriodColor,
    title: previousPeriodLabel
  }] : [])];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    style: {
      position: 'relative'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  }, (0, _use_fetcher.isPending)(status) && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 29
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.mobile.errors.httpErrorRate', {
    defaultMessage: 'HTTP Error Rate'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.apm.mobile.errors.httpErrorRateTooltip', {
      defaultMessage: 'Http error rate consisting of 4xx & 5xx.'
    }),
    position: "right",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_timeseries_chart_with_context.TimeseriesChartWithContext, {
    id: "httpErrors",
    height: height,
    showAnnotations: false,
    fetchStatus: status,
    timeseries: timeseries,
    customTheme: comparisonChartTheme,
    yLabelFormat: y => `${y}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }));
}