"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AiAssistantSelectionPage = AiAssistantSelectionPage;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _docLinks = require("@kbn/doc-links");
var _app_context = require("../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/ai_assistant_management/selection/public/routes/components/ai_assistant_selection_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AiAssistantSelectionPage() {
  var _capabilities$observa;
  const {
    capabilities,
    setBreadcrumbs,
    navigateToApp,
    buildFlavor,
    kibanaBranch,
    securityAIAssistantEnabled
  } = (0, _app_context.useAppContext)();
  const aiAssistantManagementSelection = capabilities.management.ai.aiAssistantManagementSelection;
  const observabilityAIAssistantEnabled = (_capabilities$observa = capabilities.observabilityAIAssistant) === null || _capabilities$observa === void 0 ? void 0 : _capabilities$observa.show;
  const securityAIAssistantVisibility = Boolean(capabilities.securitySolutionAssistant['ai-assistant']);
  const isSecurityAIAssistantEnabled = securityAIAssistantEnabled && aiAssistantManagementSelection && securityAIAssistantVisibility;
  const observabilityDoc = (0, _docLinks.getDocLinks)({
    buildFlavor,
    kibanaBranch
  }).observability.aiAssistant;
  const securityDoc = (0, _docLinks.getDocLinks)({
    buildFlavor,
    kibanaBranch
  }).securitySolution.aiAssistant.home;
  (0, _react.useEffect)(() => {
    setBreadcrumbs([{
      text: _i18n.i18n.translate('aiAssistantManagementSelection.breadcrumb.index', {
        defaultMessage: 'AI Assistants'
      })
    }]);
  }, [setBreadcrumbs]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    "data-test-subj": "pluginsAiAssistantSelectionPageTitle",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSettingsPage.h2.aIAssistantLabel', {
    defaultMessage: 'AI Assistants'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "pluginsAiAssistantSelectionPageDescription",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSettingsPage.descriptionTextLabel', {
    defaultMessage: 'AI Assistants use generative AI to help your team by explaining errors, suggesting remediation, and helping you request, analyze, and visualize your data.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": "aiAssistantSelectionPageObservabilityCard",
    description: /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 15
      }
    }, !observabilityAIAssistantEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 21
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "warning",
      "data-test-subj": "pluginsAiAssistantSelectionPageObservabilityDocumentationCallout",
      title: _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSelectionPage.observabilityAi.thisFeatureIsDisabledCallOutLabel', {
        defaultMessage: 'This feature is disabled.'
      }),
      size: "s",
      className: "eui-displayInlineBlock",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 21
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 21
      }
    })) : null, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "aiAssistantManagementSelection.aiAssistantSelectionPage.obsAssistant.documentationLinkDescription",
      defaultMessage: "For more info, refer to our {documentation}.",
      values: {
        documentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "pluginsAiAssistantSelectionPageDocumentationLink",
          external: true,
          target: "_blank",
          href: observabilityDoc,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 117,
            columnNumber: 25
          }
        }, _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSelectionPage.obsAssistant.documentationLinkLabel', {
          defaultMessage: 'documentation'
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 19
      }
    })), observabilityAIAssistantEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "gear",
      "data-test-subj": "pluginsAiAssistantSelectionPageButton",
      onClick: () => navigateToApp('management', {
        path: 'ai/observabilityAiAssistantManagement'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSelectionPage.obsAssistant.manageSettingsButtonLabel', {
      defaultMessage: 'Manage Settings'
    }))),
    display: "plain",
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      alignItems: "center",
      responsive: false,
      direction: "row",
      justifyContent: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "logoObservability",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "logoEnterpriseSearch",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 19
      }
    }))),
    isDisabled: !observabilityAIAssistantEnabled,
    title: _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSelectionPage.observabilityLabel', {
      defaultMessage: 'Elastic AI Assistant for Observability and Search'
    }),
    titleSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    description: /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 15
      }
    }, !isSecurityAIAssistantEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 21
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "warning",
      "data-test-subj": "pluginsAiAssistantSelectionPageSecurityDocumentationCallout",
      title: _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSelectionPage.securityAi.thisFeatureIsDisabledCallOutLabel', {
        defaultMessage: 'This feature is disabled.'
      }),
      size: "s",
      className: "eui-displayInlineBlock",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 21
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 21
      }
    })) : null, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "aiAssistantManagementSelection.aiAssistantSelectionPage.securityAssistant.documentationLinkDescription",
      defaultMessage: "For more info, refer to our {documentation}.",
      values: {
        documentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "securityAiAssistantSelectionPageDocumentationLink",
          external: true,
          target: "_blank",
          href: securityDoc,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 204,
            columnNumber: 25
          }
        }, _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSettingsPage.securityAssistant.documentationLinkLabel', {
          defaultMessage: 'documentation'
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 19
      }
    })), isSecurityAIAssistantEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "pluginsAiAssistantSelectionSecurityPageButton",
      iconType: "gear",
      onClick: () => navigateToApp('management', {
        path: 'ai/securityAiAssistantManagement'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSelectionPage.securityAssistant.manageSettingsButtonLabel', {
      defaultMessage: 'Manage Settings'
    }))),
    display: "plain",
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "logoSecurity",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 237,
        columnNumber: 19
      }
    }),
    isDisabled: !isSecurityAIAssistantEnabled,
    title: _i18n.i18n.translate('aiAssistantManagementSelection.aiAssistantSelectionPage.securityLabel', {
      defaultMessage: 'Elastic AI Assistant for Security'
    }),
    titleSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 11
    }
  }))));
}