"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connectorWithExtraFindDataSchema = exports.connectorSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const connectorSchema = exports.connectorSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  name: _configSchema.schema.string(),
  actionTypeId: _configSchema.schema.string(),
  config: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())),
  isMissingSecrets: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  isPreconfigured: _configSchema.schema.boolean(),
  isDeprecated: _configSchema.schema.boolean(),
  isSystemAction: _configSchema.schema.boolean()
});
const connectorWithExtraFindDataSchema = exports.connectorWithExtraFindDataSchema = connectorSchema.extends({
  referencedByCount: _configSchema.schema.number()
});