"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaffleMetricControls = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../../../common/constants");
var _get_custom_metric_label = require("../../../../../../../common/formatters/get_custom_metric_label");
var _snapshot_api = require("../../../../../../../common/http_api/snapshot_api");
var _custom_metric_form = require("./custom_metric_form");
var _metrics_context_menu = require("./metrics_context_menu");
var _mode_switcher = require("./mode_switcher");
var _metrics_edit_mode = require("./metrics_edit_mode");
var _dropdown_button = require("../../dropdown_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/waffle/metric_control/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WaffleMetricControls = ({
  onChange,
  onChangeCustomMetrics,
  metric,
  options,
  customMetrics
}) => {
  var _options$find;
  const [isPopoverOpen, setPopoverState] = (0, _react.useState)(false);
  const [mode, setMode] = (0, _react.useState)('pick');
  const [editModeCustomMetrics, setEditModeCustomMetrics] = (0, _react.useState)([]);
  const [editCustomMetric, setEditCustomMetric] = (0, _react.useState)();
  const handleClose = (0, _react.useCallback)(() => {
    setPopoverState(false);
  }, [setPopoverState]);
  const handleToggle = (0, _react.useCallback)(() => {
    setPopoverState(!isPopoverOpen);
  }, [isPopoverOpen]);
  const handleCustomMetric = (0, _react.useCallback)(newMetric => {
    onChangeCustomMetrics([...customMetrics, newMetric]);
    onChange(newMetric);
    setMode('pick');
  }, [customMetrics, onChange, onChangeCustomMetrics, setMode]);
  const setModeToEdit = (0, _react.useCallback)(() => {
    setMode('edit');
    setEditModeCustomMetrics(customMetrics);
  }, [customMetrics]);
  const setModeToAdd = (0, _react.useCallback)(() => {
    setMode('addMetric');
  }, [setMode]);
  const setModeToPick = (0, _react.useCallback)(() => {
    setMode('pick');
    setEditModeCustomMetrics([]);
  }, [setMode]);
  const handleDeleteCustomMetric = (0, _react.useCallback)(m => {
    // If the metric we are deleting is the currently selected metric
    // we need to change to the default.
    if (_snapshot_api.SnapshotCustomMetricInputRT.is(metric) && m.id === metric.id) {
      onChange({
        type: options[0].value
      });
    }
    // Filter out the deleted metric from the editbale.
    const newMetrics = editModeCustomMetrics.filter(v => v.id !== m.id);
    setEditModeCustomMetrics(newMetrics);
  }, [editModeCustomMetrics, metric, onChange, options]);
  const handleEditCustomMetric = (0, _react.useCallback)(currentMetric => {
    const newMetrics = customMetrics.map(m => m.id === currentMetric.id && currentMetric || m);
    onChangeCustomMetrics(newMetrics);
    setModeToPick();
    setEditCustomMetric(void 0);
    setEditModeCustomMetrics([]);
  }, [customMetrics, onChangeCustomMetrics, setModeToPick]);
  const handleSelectMetricToEdit = (0, _react.useCallback)(currentMetric => {
    setEditCustomMetric(currentMetric);
    setMode('editMetric');
  }, [setMode, setEditCustomMetric]);
  const handleSaveEdit = (0, _react.useCallback)(() => {
    onChangeCustomMetrics(editModeCustomMetrics);
    setMode('pick');
  }, [editModeCustomMetrics, onChangeCustomMetrics]);
  if (!metric.type) {
    throw Error(_i18n.i18n.translate('xpack.infra.waffle.unableToSelectMetricErrorTitle', {
      defaultMessage: 'Unable to select options or value for metric.'
    }));
  }
  const id = _snapshot_api.SnapshotCustomMetricInputRT.is(metric) && metric.id ? metric.id : metric.type;
  const currentLabel = _snapshot_api.SnapshotCustomMetricInputRT.is(metric) ? (0, _get_custom_metric_label.getCustomMetricLabel)(metric) : (_options$find = options.find(o => o.value === id)) === null || _options$find === void 0 ? void 0 : _options$find.text;
  if (!currentLabel) {
    return null;
  }
  const canAdd = options.length + customMetrics.length < _constants.SNAPSHOT_API_MAX_METRICS;
  const button = /*#__PURE__*/_react.default.createElement(_dropdown_button.DropdownButton, {
    onClick: handleToggle,
    label: _i18n.i18n.translate('xpack.infra.waffle.metriclabel', {
      defaultMessage: 'Metric'
    }),
    "data-test-subj": "infraInventoryMetricDropdown",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 5
    }
  }, currentLabel);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    id: "metricsPanel",
    button: button,
    anchorPosition: "downLeft",
    panelPaddingSize: "none",
    closePopover: handleClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }, mode === 'pick' ? /*#__PURE__*/_react.default.createElement(_metrics_context_menu.MetricsContextMenu, {
    onChange: onChange,
    onClose: handleClose,
    metric: metric,
    customMetrics: customMetrics,
    options: options,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  }) : null, mode === 'addMetric' ? /*#__PURE__*/_react.default.createElement(_custom_metric_form.CustomMetricForm, {
    customMetrics: customMetrics,
    onChange: handleCustomMetric,
    onCancel: setModeToPick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  }) : null, mode === 'editMetric' ? /*#__PURE__*/_react.default.createElement(_custom_metric_form.CustomMetricForm, {
    metric: editCustomMetric,
    customMetrics: customMetrics,
    onChange: handleEditCustomMetric,
    onCancel: setModeToEdit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 11
    }
  }) : null, mode === 'edit' ? /*#__PURE__*/_react.default.createElement(_metrics_edit_mode.MetricsEditMode, {
    customMetrics: editModeCustomMetrics,
    options: options,
    onEdit: handleSelectMetricToEdit,
    onDelete: handleDeleteCustomMetric,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 11
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_mode_switcher.ModeSwitcher, {
    onEditCancel: setModeToPick,
    onEdit: setModeToEdit,
    onAdd: setModeToAdd,
    mode: mode,
    onSave: handleSaveEdit,
    customMetrics: customMetrics,
    disableAdd: !canAdd,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 9
    }
  })));
};
exports.WaffleMetricControls = WaffleMetricControls;