"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _ebtTools = require("@kbn/ebt-tools");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _metrics_source = require("../../../../../containers/metrics_source");
var _unified_search_bar = require("../../../../../components/shared/unified_search_bar");
var _use_unified_search = require("../../hooks/use_unified_search");
var _controls_content = require("./controls_content");
var _limit_options = require("./limit_options");
var _use_time_range_metadata = require("../../../../../hooks/use_time_range_metadata");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/hosts/components/search_bar/search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchBar = () => {
  const {
    searchCriteria,
    onLimitChange,
    onPanelFiltersChange,
    onSubmit,
    onPreferredSchemaChange
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    onPageRefreshStart
  } = (0, _ebtTools.usePerformanceContext)();
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const {
    data: timeRangeMetadata
  } = (0, _use_time_range_metadata.useTimeRangeMetadataContext)();
  const schemas = (0, _react.useMemo)(() => (timeRangeMetadata === null || timeRangeMetadata === void 0 ? void 0 : timeRangeMetadata.schemas) || [], [timeRangeMetadata === null || timeRangeMetadata === void 0 ? void 0 : timeRangeMetadata.schemas]);

  // Set preferredSchema in URL if not set
  (0, _react.useEffect)(() => {
    if (!timeRangeMetadata || schemas.length === 0) return;
    const current = searchCriteria.preferredSchema;
    if (current === null) {
      onPreferredSchemaChange(timeRangeMetadata.preferredSchema);
    }
  }, [timeRangeMetadata, searchCriteria.preferredSchema, onPreferredSchemaChange, schemas]);
  const handleRefresh = (0, _react.useCallback)((payload, isUpdate) => {
    // This makes sure `onSubmit` is only called when the submit button is clicked
    if (isUpdate === false) {
      onSubmit(payload);
      onPageRefreshStart();
    }
  }, [onSubmit, onPageRefreshStart]);
  return /*#__PURE__*/_react.default.createElement(StickyContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_unified_search_bar.UnifiedSearchBar, {
    onQuerySubmit: handleRefresh,
    placeholder: searchCriteria.preferredSchema === 'ecs' ? _i18n.i18n.translate('xpack.infra.hosts.searchPlaceholder', {
      defaultMessage: 'Search hosts (E.g. cloud.provider:gcp AND system.load.1 > 0.5)'
    }) : _i18n.i18n.translate('xpack.infra.hosts.otelSearchPlaceholder', {
      defaultMessage: 'Search hosts (E.g. cloud.provider:gcp AND os.type:linux)'
    }),
    showDatePicker: true,
    showFilterBar: true,
    showSubmitButton: true,
    showQueryMenu: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    wrap: false,
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_controls_content.ControlsContent, {
    timeRange: searchCriteria.dateRange,
    dataView: metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference,
    query: searchCriteria.query,
    filters: searchCriteria.filters,
    onFiltersChange: onPanelFiltersChange,
    schema: searchCriteria.preferredSchema,
    schemas: schemas,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_limit_options.LimitOptions, {
    limit: searchCriteria.limit,
    onChange: onLimitChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    css: (0, _react2.css)`
          margin-bottom: 0;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }));
};
exports.SearchBar = SearchBar;
const StickyContainer = ({
  children
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        position: sticky;
        top: var(--kbnAppHeadersOffset, var(--euiFixedHeadersOffset, 0));
        z-index: ${euiTheme.levels.navigation};
        background: ${euiTheme.colors.emptyShade};
        padding: ${euiTheme.size.l} ${euiTheme.size.l} 0px;
        margin: -${euiTheme.size.l} -${euiTheme.size.l} 0px;
        min-height: calc(${euiTheme.size.xxxl} * 2);
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 5
    }
  }, children);
};