"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTrialStatus = useTrialStatus;
var _ioTs = require("io-ts");
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _constants = require("@kbn/license-management-plugin/common/constants");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _use_tracked_promise = require("./use_tracked_promise");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useTrialStatus() {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [isTrialAvailable, setIsTrialAvailable] = (0, _react.useState)(false);
  const [loadState, checkTrialAvailability] = (0, _use_tracked_promise.useTrackedPromise)({
    createPromise: async () => {
      // since license_management plugin is not available in serverless this is to avoid the below api call
      if (services !== null && services !== void 0 && services.serverless) {
        return false;
      }
      const response = await services.http.get(`${_constants.API_BASE_PATH}/start_trial`);
      return (0, _ioTsUtils.decodeOrThrow)(_ioTs.boolean)(response);
    },
    onResolve: response => {
      setIsTrialAvailable(response);
    },
    onReject: () => {
      services.notifications.toasts.addDanger(_i18n.i18n.translate('xpack.infra.trialStatus.trialStatusNetworkErrorMessage', {
        defaultMessage: 'We could not determine if the trial license is available'
      }));
    }
  }, [services]);
  return {
    loadState: loadState.state,
    isTrialAvailable,
    checkTrialAvailability
  };
}