"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _use_kibana = require("../../../hooks/use_kibana");
var _create_alerts_es_query = require("../../../utils/filters/create_alerts_es_query");
var _constants2 = require("./constants");
var _alerts_status_filter = _interopRequireDefault(require("./alerts_status_filter"));
var _use_asset_details_url_state = require("../../asset_details/hooks/use_asset_details_url_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/components/shared/alerts/alerts_overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertsOverview = ({
  entityId,
  dateRange,
  onLoaded,
  onRangeSelection,
  entityType
}) => {
  var _urlState$alertStatus;
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [urlState, setUrlState] = (0, _use_asset_details_url_state.useAssetDetailsUrlState)();
  const [alertStatus, setAlertStatus] = (0, _react.useState)((_urlState$alertStatus = urlState === null || urlState === void 0 ? void 0 : urlState.alertStatus) !== null && _urlState$alertStatus !== void 0 ? _urlState$alertStatus : _constants2.ALERT_STATUS_ALL);
  const {
    charts,
    triggersActionsUi: {
      getAlertSummaryWidget: AlertSummaryWidget
    },
    data,
    http,
    notifications,
    fieldFormats,
    application,
    licensing,
    cases,
    settings
  } = services;
  const baseTheme = charts.theme.useChartsBaseTheme();
  const alertsEsQueryByStatus = (0, _react.useMemo)(() => (0, _create_alerts_es_query.createAlertsEsQuery)({
    dateRange,
    entityIds: [entityId],
    status: alertStatus,
    entityType
  }), [dateRange, entityId, alertStatus, entityType]);
  const alertsEsQuery = (0, _react.useMemo)(() => (0, _create_alerts_es_query.createAlertsEsQuery)({
    dateRange,
    entityIds: [entityId],
    status: _constants2.ALERT_STATUS_ALL,
    entityType
  }), [entityId, entityType, dateRange]);
  const summaryTimeRange = (0, _public.useSummaryTimeRange)(dateRange);
  const onBrushEnd = (0, _react.useCallback)(brushEvent => {
    const {
      x
    } = brushEvent;
    if (x && onRangeSelection) {
      const [start, end] = x;
      const from = new Date(start).toISOString();
      const to = new Date(end).toISOString();
      onRangeSelection({
        from,
        to
      });
    }
  }, [onRangeSelection]);
  const chartProps = (0, _react.useMemo)(() => ({
    baseTheme,
    onBrushEnd
  }), [onBrushEnd, baseTheme]);
  const handleAlertStatusChange = id => {
    setAlertStatus(id);
    setUrlState({
      alertStatus: id
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    "data-test-subj": "hostsView-alerts",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_alerts_status_filter.default, {
    onChange: handleAlertStatusChange,
    status: alertStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(AlertSummaryWidget, {
    chartProps: chartProps,
    ruleTypeIds: _ruleDataUtils.OBSERVABILITY_RULE_TYPE_IDS,
    consumers: _constants.INFRA_ALERT_CONSUMERS,
    filter: alertsEsQuery,
    timeRange: summaryTimeRange,
    onLoaded: onLoaded,
    fullSize: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public.ObservabilityAlertsTable, {
    id: 'assetDetailsAlertsTable',
    ruleTypeIds: _ruleDataUtils.OBSERVABILITY_RULE_TYPE_IDS,
    consumers: _constants.INFRA_ALERT_CONSUMERS,
    query: alertsEsQueryByStatus,
    pageSize: 5,
    services: {
      data,
      http,
      notifications,
      fieldFormats,
      application,
      licensing,
      cases,
      settings
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  })));
};
exports.AlertsOverview = AlertsOverview;