"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalysisSetupTimerangeForm = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _fixed_datepicker = require("../../../fixed_datepicker");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/components/logging/log_analysis_setup/initial_configuration_step/analysis_setup_timerange_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const startTimeLabel = _i18n.i18n.translate('xpack.infra.analysisSetup.startTimeLabel', {
  defaultMessage: 'Start time'
});
const endTimeLabel = _i18n.i18n.translate('xpack.infra.analysisSetup.endTimeLabel', {
  defaultMessage: 'End time'
});
const startTimeDefaultDescription = _i18n.i18n.translate('xpack.infra.analysisSetup.startTimeDefaultDescription', {
  defaultMessage: 'Start of log indices'
});
const endTimeDefaultDescription = _i18n.i18n.translate('xpack.infra.analysisSetup.endTimeDefaultDescription', {
  defaultMessage: 'Indefinitely'
});
function selectedDateToParam(selectedDate) {
  if (selectedDate) {
    return selectedDate.valueOf(); // To ms unix timestamp
  }
  return undefined;
}
const AnalysisSetupTimerangeForm = ({
  disabled = false,
  setStartTime,
  setEndTime,
  startTime,
  endTime,
  validationErrors = []
}) => {
  const [now] = (0, _react.useState)(() => (0, _moment.default)());
  const selectedEndTimeIsToday = !endTime || (0, _moment.default)(endTime).isSame(now, 'day');
  const startTimeValue = (0, _react.useMemo)(() => {
    return startTime ? (0, _moment.default)(startTime) : undefined;
  }, [startTime]);
  const endTimeValue = (0, _react.useMemo)(() => {
    return endTime ? (0, _moment.default)(endTime) : undefined;
  }, [endTime]);
  const startTimeValidationErrorMessages = (0, _react.useMemo)(() => getStartTimeValidationErrorMessages(validationErrors), [validationErrors]);
  const endTimeValidationErrorMessages = (0, _react.useMemo)(() => getEndTimeValidationErrorMessages(validationErrors), [validationErrors]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.analysisSetup.timeRangeTitle",
    defaultMessage: "Choose a time range",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.analysisSetup.timeRangeDescription",
    defaultMessage: "By default, Machine Learning analyzes log messages in your log indices no older than four weeks, and continues indefinitely. You can specify a different date to begin, to end, or both.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: startTimeValidationErrorMessages,
    fullWidth: true,
    isInvalid: startTimeValidationErrorMessages.length > 0,
    label: startTimeLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_fixed_datepicker.FixedDatePicker, {
    disabled: disabled,
    showTimeSelect: true,
    selected: startTimeValue,
    onChange: date => setStartTime(selectedDateToParam(date)),
    onClear: () => setStartTime(undefined),
    placeholder: startTimeDefaultDescription,
    maxDate: now,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: endTimeValidationErrorMessages,
    fullWidth: true,
    isInvalid: endTimeValidationErrorMessages.length > 0,
    label: endTimeLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_fixed_datepicker.FixedDatePicker, {
    disabled: disabled,
    showTimeSelect: true,
    selected: endTimeValue,
    onChange: date => setEndTime(selectedDateToParam(date)),
    onClear: () => setEndTime(undefined),
    placeholder: endTimeDefaultDescription,
    openToDate: now,
    minDate: startTimeValue,
    minTime: selectedEndTimeIsToday ? now : (0, _moment.default)().hour(0).minutes(0),
    maxTime: (0, _moment.default)().hour(23).minutes(59),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 13
    }
  })))));
};
exports.AnalysisSetupTimerangeForm = AnalysisSetupTimerangeForm;
const getStartTimeValidationErrorMessages = validationErrors => validationErrors.flatMap(validationError => {
  switch (validationError.error) {
    case 'INVALID_TIME_RANGE':
      return [_i18n.i18n.translate('xpack.infra.analysisSetup.startTimeBeforeEndTimeErrorMessage', {
        defaultMessage: 'The start time must be before the end time.'
      })];
    default:
      return [];
  }
});
const getEndTimeValidationErrorMessages = validationErrors => validationErrors.flatMap(validationError => {
  switch (validationError.error) {
    case 'INVALID_TIME_RANGE':
      return [_i18n.i18n.translate('xpack.infra.analysisSetup.endTimeAfterStartTimeErrorMessage', {
        defaultMessage: 'The end time must be after the start time.'
      })];
    default:
      return [];
  }
});