"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetsSelector = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _log_analysis = require("../../../../common/log_analysis");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/components/logging/log_analysis_results/datasets_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DatasetsSelector = ({
  availableDatasets,
  isLoading = false,
  onChangeDatasetSelection,
  selectedDatasets
}) => {
  const options = (0, _react.useMemo)(() => availableDatasets.map(dataset => ({
    value: dataset,
    label: (0, _log_analysis.getFriendlyNameForPartitionId)(dataset)
  })), [availableDatasets]);
  const selectedOptions = (0, _react.useMemo)(() => options.filter(({
    value
  }) => value != null && selectedDatasets.includes(value)), [options, selectedDatasets]);
  const handleChange = (0, _react.useCallback)(newSelectedOptions => onChangeDatasetSelection(newSelectedOptions.map(({
    value
  }) => value).filter(isDefined)), [onChangeDatasetSelection]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": datasetFilterPlaceholder,
    isLoading: isLoading,
    onChange: handleChange,
    options: options,
    placeholder: datasetFilterPlaceholder,
    selectedOptions: selectedOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  });
};
exports.DatasetsSelector = DatasetsSelector;
const datasetFilterPlaceholder = _i18n.i18n.translate('xpack.infra.logs.analysis.datasetFilterPlaceholder', {
  defaultMessage: 'Filter by datasets'
});
const isDefined = value => value != null;