"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MappingsFilter = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _mappings_state_context = require("../../../../components/mappings_editor/mappings_state_context");
var _lib = require("../../../../components/mappings_editor/lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/index_list/details_page/details_page_filter_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MappingsFilter = ({
  isAddingFields,
  isJSONVisible,
  previousState,
  setPreviousState,
  state
}) => {
  const [isFilterByPopoverVisible, setIsFilterPopoverVisible] = (0, _react.useState)(false);
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const isClearAllFilterDisabled = !isAddingFields ? state.filter.selectedOptions.filter(option => option.checked === 'on').length === 0 : previousState.filter.selectedOptions.filter(option => option.checked === 'on').length === 0;
  const setSelectedOptions = (0, _react.useCallback)(options => {
    dispatch({
      type: 'filter:update',
      value: {
        selectedOptions: options
      }
    });
    dispatch({
      type: 'search:update',
      value: state.search.term
    });
  }, [dispatch, state.search.term]);
  const setPreviousStateSelectedOptions = (0, _react.useCallback)(options => {
    const selectedDataTypes = options.filter(option => option.checked === 'on').map(option => option.label);
    setPreviousState({
      ...previousState,
      filter: {
        filteredFields: (0, _lib.getFieldsFromState)(previousState.fields, selectedDataTypes.length > 0 ? selectedDataTypes : undefined),
        selectedOptions: options,
        selectedDataTypes
      },
      search: {
        term: previousState.search.term,
        result: (0, _lib.searchFields)(previousState.search.term, selectedDataTypes.length > 0 ? (0, _lib.getFieldsMatchingFilterFromState)(previousState, selectedDataTypes) : previousState.fields.byId)
      }
    });
  }, [previousState, setPreviousState]);
  const filterByFieldTypeButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    iconType: "arrowDown",
    iconSide: "right",
    isDisabled: isJSONVisible,
    onClick: () => setIsFilterPopoverVisible(!isFilterByPopoverVisible),
    numFilters: !isAddingFields ? state.filter.selectedOptions.length : previousState.filter.selectedOptions.length,
    hasActiveFilters: !isAddingFields ? state.filter.selectedDataTypes.length > 0 : previousState.filter.selectedDataTypes.length > 0,
    numActiveFilters: !isAddingFields ? state.filter.selectedDataTypes.length : previousState.filter.selectedDataTypes.length,
    isSelected: isFilterByPopoverVisible,
    "data-test-subj": "indexDetailsMappingsFilterByFieldTypeButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.mappings.filterByFieldType.button', {
    defaultMessage: 'Field types'
  }));
  const clearOptions = () => {
    const clearCheckedOptions = options => {
      return options.map(option => option.checked === 'on' ? {
        ...option,
        checked: undefined
      } : option);
    };
    if (!isAddingFields) {
      setSelectedOptions(clearCheckedOptions(state.filter.selectedOptions));
    } else {
      setPreviousStateSelectedOptions(clearCheckedOptions(previousState.filter.selectedOptions));
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: filterByFieldTypeButton,
    isOpen: isFilterByPopoverVisible,
    closePopover: () => setIsFilterPopoverVisible(!isFilterByPopoverVisible),
    anchorPosition: "downCenter",
    "data-test-subj": "indexDetailsMappingsFilter",
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    searchable: true,
    "data-test-subj": "filterItem",
    searchProps: {
      placeholder: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.mappings.filterByFieldType.searchPlaceholder', {
        defaultMessage: 'Filter list '
      })
    },
    options: !isAddingFields ? state.filter.selectedOptions : previousState.filter.selectedOptions,
    onChange: options => {
      if (!isAddingFields) {
        setSelectedOptions(options);
      } else {
        setPreviousStateSelectedOptions(options);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 200
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s",
    "data-test-subj": "indexDetailsMappingsFilterByFieldTypeSearch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 15
    }
  }, search), list)), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    paddingSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "danger",
    size: "s",
    "data-test-subj": "clearFilters",
    disabled: isClearAllFilterDisabled,
    onClick: clearOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.mappings.filterByFieldType.filter.clearAll', {
    defaultMessage: 'Clear all'
  }))))));
};
exports.MappingsFilter = MappingsFilter;