"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _sharedUxTablePersist = require("@kbn/shared-ux-table-persist");
var _constants = require("../../../../../../common/constants");
var _app_context = require("../../../../app_context");
var _data_streams = require("../../../../lib/data_streams");
var _shared_imports = require("../../../../../shared_imports");
var _routing = require("../../../../services/routing");
var _components = require("../../../../components");
var _delete_data_stream_confirmation_modal = require("../delete_data_stream_confirmation_modal");
var _humanize_time_stamp = require("../humanize_time_stamp");
var _data_stream_badges = require("../data_stream_badges");
var _data_stream_detail_panel = require("../data_stream_detail_panel");
var _index_mode_labels = require("../../../../lib/index_mode_labels");
var _components2 = require("../../components");
var _data_stream_actions_menu = require("../data_stream_actions_menu");
var _edit_data_retention_modal = require("../edit_data_retention_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/data_stream_list/data_stream_table/data_stream_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INFINITE_AS_ICON = true;
const PAGE_SIZE_OPTIONS = [10, 20, 50];
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    bulkDeleteButton: (0, _react.css)`
      color: ${euiTheme.colors.danger};
    `
  };
};
const DataStreamTable = ({
  dataStreams,
  reload,
  history,
  filters,
  includeStats,
  setIncludeStats,
  onViewFilterChange,
  viewFilters
}) => {
  const styles = useStyles();
  const [selection, setSelection] = (0, _react2.useState)([]);
  const [dataStreamsToDelete, setDataStreamsToDelete] = (0, _react2.useState)([]);
  const [dataStreamsToEditDataRetention, setDataStreamsToEditDataRetention] = (0, _react2.useState)([]);
  const {
    config
  } = (0, _app_context.useAppContext)();
  const data = (0, _react2.useMemo)(() => {
    return (dataStreams || []).map(dataStream => ({
      ...dataStream,
      isDataStreamFullyManagedByILM: (0, _data_streams.isDataStreamFullyManagedByILM)(dataStream)
    }));
  }, [dataStreams]);
  const columns = [];
  columns.push({
    field: 'name',
    name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.nameColumnTitle', {
      defaultMessage: 'Name'
    }),
    truncateText: true,
    sortable: true,
    render: (name, dataStream) => {
      return /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, (0, _extends2.default)({
        role: "button",
        "data-test-subj": "nameLink"
      }, (0, _shared_imports.reactRouterNavigate)(history, (0, _routing.getDataStreamDetailsLink)(name)), {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 11
        }
      }), name), /*#__PURE__*/_react2.default.createElement(_data_stream_badges.DataStreamsBadges, {
        dataStream: dataStream,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 11
        }
      }));
    }
  });
  columns.push({
    field: 'health',
    name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.healthColumnTitle', {
      defaultMessage: 'Health'
    }),
    truncateText: true,
    sortable: true,
    render: health => {
      return /*#__PURE__*/_react2.default.createElement(_components.DataHealth, {
        health: health,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 14
        }
      });
    }
  });
  if (includeStats) {
    if (config.enableSizeAndDocCount) {
      // datastreams stats from metering API on serverless
      columns.push({
        field: 'meteringStorageSizeBytes',
        name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.storageSizeColumnTitle', {
          defaultMessage: 'Storage size'
        }),
        truncateText: true,
        sortable: true,
        render: (meteringStorageSizeBytes, dataStream) => dataStream.meteringStorageSize
      });
      columns.push({
        field: 'meteringDocsCount',
        name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.docsCountColumnTitle', {
          defaultMessage: 'Documents count'
        }),
        truncateText: true,
        sortable: true
      });
    }
    if (config.enableDataStreamStats) {
      columns.push({
        field: 'maxTimeStamp',
        name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.maxTimeStampColumnTitle', {
          defaultMessage: 'Last updated'
        }),
        truncateText: true,
        sortable: true,
        render: maxTimeStamp => maxTimeStamp ? (0, _humanize_time_stamp.humanizeTimeStamp)(maxTimeStamp) : _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.maxTimeStampColumnNoneMessage', {
          defaultMessage: 'Never'
        })
      });
      columns.push({
        field: 'storageSizeBytes',
        name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.storageSizeColumnTitle', {
          defaultMessage: 'Storage size'
        }),
        truncateText: true,
        sortable: true,
        render: (storageSizeBytes, dataStream) => dataStream.storageSize
      });
    }
  }
  columns.push({
    field: 'indices',
    name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.indicesColumnTitle', {
      defaultMessage: 'Indices'
    }),
    truncateText: true,
    sortable: true,
    render: (indices, dataStream) => /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, (0, _extends2.default)({
      "data-test-subj": "indicesLink"
    }, (0, _shared_imports.reactRouterNavigate)(history, (0, _routing.getIndexListUri)(`data_stream="${dataStream.name}"`, true)), {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 7
      }
    }), indices.length)
  });
  columns.push({
    field: 'indexMode',
    name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.indexModeColumnTitle', {
      defaultMessage: 'Index mode'
    }),
    truncateText: true,
    sortable: true,
    render: indexMode => _index_mode_labels.indexModeLabels[indexMode]
  });
  columns.push({
    field: 'lifecycle',
    name: /*#__PURE__*/_react2.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.dataRetentionColumnTitle', {
      defaultMessage: 'Data retention'
    }), ' ', /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.dataRetentionColumnTooltip', {
        defaultMessage: `Data is kept at least this long before being automatically deleted. The data retention value only applies to the data managed directly by the data stream. {canDisableDataRetention, plural, one {If some data is subject to an index lifecycle management policy, then the data retention value set for the data stream doesn't apply to that data.} other {}}`,
        values: {
          // ILM is not applicable on serverless, so when the user isnt able to
          // disable data retention (which is only for serverless) we want to
          // tweak the copy of the tooltip to hide any references to it.
          canDisableDataRetention: config.enableTogglingDataRetention ? 1 : 0
        }
      }),
      position: "top",
      type: "question",
      size: "s",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 9
      }
    })),
    truncateText: true,
    sortable: true,
    render: (lifecycle, dataStream) => /*#__PURE__*/_react2.default.createElement(_data_stream_detail_panel.ConditionalWrap, {
      condition: dataStream.isDataStreamFullyManagedByILM,
      wrap: children => /*#__PURE__*/_react2.default.createElement(_eui.EuiTextColor, {
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 246,
          columnNumber: 29
        }
      }, children),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, (0, _data_streams.getLifecycleValue)(lifecycle, INFINITE_AS_ICON), (lifecycle === null || lifecycle === void 0 ? void 0 : lifecycle.retention_determined_by) === _constants.MAX_DATA_RETENTION && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, ' ', /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.usingEffectiveRetentionTooltip', {
        defaultMessage: `This data stream is using the maximum allowed data retention: [{effectiveRetention}].`,
        values: {
          effectiveRetention: lifecycle === null || lifecycle === void 0 ? void 0 : lifecycle.effective_retention
        }
      }),
      position: "top",
      type: "info",
      size: "s",
      color: "subdued",
      iconProps: {
        'data-test-subj': 'usingMaxRetention'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 15
      }
    }))))
  });
  columns.push({
    name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.actionColumnTitle', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.actionDeleteText', {
        defaultMessage: 'Delete'
      }),
      description: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.actionDeleteDescription', {
        defaultMessage: 'Delete this data stream'
      }),
      icon: 'trash',
      color: 'danger',
      type: 'icon',
      onClick: ({
        name
      }) => {
        setDataStreamsToDelete([name]);
      },
      isPrimary: true,
      'data-test-subj': 'deleteDataStream',
      available: ({
        privileges: {
          delete_index: deleteIndex
        }
      }) => deleteIndex
    }]
  });
  const selectionConfig = {
    onSelectionChange: setSelection
  };
  const dataStreamActions = [];
  if (selection.every(dataStream => dataStream.privileges.manage_data_stream_lifecycle && !(0, _data_streams.isDataStreamFullyManagedByILM)(dataStream))) {
    dataStreamActions.push({
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.bulkEditDataRetentionButtonLabel', {
        defaultMessage: 'Edit data retention'
      }),
      icon: 'pencil',
      onClick: () => setDataStreamsToEditDataRetention(selection),
      'data-test-subj': 'bulkEditDataRetentionButton'
    });
  }
  if (selection.every(dataStream => dataStream.privileges.delete_index)) {
    dataStreamActions.push({
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.deleteDataStreamsButtonLabel', {
        defaultMessage: 'Delete data streams'
      }),
      icon: 'trash',
      onClick: () => setDataStreamsToDelete(selection.map(({
        name
      }) => name)),
      css: styles.bulkDeleteButton,
      'data-test-subj': 'deleteDataStreamsButton'
    });
  }
  const searchConfig = {
    query: filters,
    box: {
      incremental: true
    },
    toolsLeft: selection.length > 0 && dataStreamActions.length > 0 ? /*#__PURE__*/_react2.default.createElement(_data_stream_actions_menu.DataStreamActionsMenu, {
      dataStreamActions: dataStreamActions,
      selectedDataStreamsCount: selection.length,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 344,
        columnNumber: 9
      }
    }) : undefined,
    toolsRight: [/*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 350,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 351,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSwitch, {
      label: _i18n.i18n.translate('xpack.idxMgmt.dataStreamListControls.includeStatsSwitchLabel', {
        defaultMessage: 'Include stats'
      }),
      checked: includeStats,
      onChange: e => setIncludeStats(e.target.checked),
      "data-test-subj": "includeStatsSwitch",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 352,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 362,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.idxMgmt.dataStreamListControls.includeStatsSwitchToolTip', {
        defaultMessage: 'Including stats can increase reload times'
      }),
      position: "top",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 363,
        columnNumber: 11
      }
    }))), /*#__PURE__*/_react2.default.createElement(_components2.FilterListButton, {
      filters: viewFilters,
      onChange: onViewFilterChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 374,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      color: "success",
      iconType: "refresh",
      onClick: reload,
      "data-test-subj": "reloadButton",
      key: "reloadButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 378,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.dataStreamList.reloadDataStreamsButtonLabel",
      defaultMessage: "Reload",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 385,
        columnNumber: 9
      }
    }))]
  };
  const {
    pageSize,
    sorting,
    onTableChange
  } = (0, _sharedUxTablePersist.useEuiTablePersist)({
    tableId: 'dataStreams',
    initialPageSize: 20,
    initialSort: {
      field: 'name',
      direction: 'asc'
    },
    pageSizeOptions: PAGE_SIZE_OPTIONS
  });
  const pagination = {
    pageSize,
    pageSizeOptions: PAGE_SIZE_OPTIONS
  };
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, dataStreamsToEditDataRetention && dataStreamsToEditDataRetention.length > 0 ? /*#__PURE__*/_react2.default.createElement(_edit_data_retention_modal.EditDataRetentionModal, {
    onClose: res => {
      if (res && res.hasUpdatedDataRetention) {
        reload();
      } else {
        setDataStreamsToEditDataRetention([]);
      }
    },
    dataStreams: dataStreamsToEditDataRetention,
    isBulkEdit: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 411,
      columnNumber: 9
    }
  }) : null, dataStreamsToDelete && dataStreamsToDelete.length > 0 ? /*#__PURE__*/_react2.default.createElement(_delete_data_stream_confirmation_modal.DeleteDataStreamConfirmationModal, {
    onClose: res => {
      if (res && res.hasDeletedDataStreams) {
        reload();
      } else {
        setDataStreamsToDelete([]);
      }
    },
    dataStreams: dataStreamsToDelete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 424,
      columnNumber: 9
    }
  }) : null, /*#__PURE__*/_react2.default.createElement(_eui.EuiInMemoryTable, {
    items: data,
    itemId: "name",
    columns: columns,
    search: searchConfig,
    sorting: sorting,
    selection: selectionConfig,
    pagination: pagination,
    rowProps: () => ({
      'data-test-subj': 'row'
    }),
    cellProps: () => ({
      'data-test-subj': 'cell'
    }),
    "data-test-subj": "dataStreamTable",
    message: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.dataStreamList.table.noDataStreamsMessage",
      defaultMessage: "No data streams found",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 451,
        columnNumber: 11
      }
    }),
    tableLayout: 'auto',
    onTableChange: onTableChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 435,
      columnNumber: 7
    }
  }));
};
exports.DataStreamTable = DataStreamTable;