"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormatParameter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _edit_field = require("../fields/edit_field");
var _shared_imports = require("../../../shared_imports");
var _constants = require("../../../constants");
var _lib = require("../../../lib");
var _documentation = require("../../../../../services/documentation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/format_parameter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FormatParameter = ({
  defaultValue,
  defaultToggleValue
}) => {
  const defaultValueArray = defaultValue !== undefined ? defaultValue.split('||').map(value => ({
    label: value
  })) : [];
  const defaultValuesInOptions = defaultValueArray.filter(defaultFormat => _constants.ALL_DATE_FORMAT_OPTIONS.includes(defaultFormat));
  const [comboBoxOptions, setComboBoxOptions] = (0, _react.useState)([..._constants.ALL_DATE_FORMAT_OPTIONS, ...defaultValuesInOptions]);
  return /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
    title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.formatParameter.fieldTitle', {
      defaultMessage: 'Set format'
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.formatParameter.fieldDescription",
      defaultMessage: "The date formats to parse. Most builit-ins use {strict} date formats, where YYYY is the year, MM is the month, and DD is the day. Example: 2020/11/01.",
      values: {
        strict: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 48,
            columnNumber: 21
          }
        }, "strict")
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    }),
    docLink: {
      text: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.formatDocLinkText', {
        defaultMessage: 'Format documentation'
      }),
      href: _documentation.documentationService.getFormatLink()
    },
    defaultToggleValue: defaultToggleValue,
    "data-test-subj": "formatParameter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "format",
    config: (0, _lib.getFieldConfig)('format'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, formatField => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: formatField.label,
      helpText: formatField.helpText,
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      placeholder: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.formatParameter.placeholderLabel', {
        defaultMessage: 'Select a format'
      }),
      options: comboBoxOptions,
      selectedOptions: formatField.value,
      onChange: value => {
        formatField.setValue(value);
      },
      onCreateOption: searchValue => {
        const newOption = {
          label: searchValue
        };
        formatField.setValue([...formatField.value, newOption]);
        setComboBoxOptions([...comboBoxOptions, newOption]);
      },
      fullWidth: true,
      "data-test-subj": "formatInput",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 15
      }
    }));
  }));
};
exports.FormatParameter = FormatParameter;