"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DynamicMappingSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _documentation = require("../../../../../services/documentation");
var _shared_imports = require("../../../shared_imports");
var _constants = require("../../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/configuration_form/dynamic_mapping_section/dynamic_mapping_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const UseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const DynamicMappingSection = () => /*#__PURE__*/_react.default.createElement(_shared_imports.FormRow, {
  title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dynamicMappingTitle', {
    defaultMessage: 'Dynamic mapping'
  }),
  description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.mappingsEditor.dynamicMappingDescription",
    defaultMessage: "Dynamic mapping allows an index template to interpret unmapped fields. {docsLink}",
    values: {
      docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _documentation.documentationService.getDynamicMappingLink(),
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 39,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dynamicMappingDocumentionLink', {
        defaultMessage: 'Learn more.'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(UseField, {
    path: "dynamicMapping.enabled",
    component: _shared_imports.ToggleField,
    componentProps: {
      'data-test-subj': 'dynamicMappingsToggle'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  })),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 28,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
  pathsToWatch: ['dynamicMapping.enabled', 'dynamicMapping.date_detection'],
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 56,
    columnNumber: 5
  }
}, formData => {
  const {
    dynamicMapping: {
      enabled,
      date_detection: dateDetection
    }
  } = formData;
  if (enabled === undefined) {
    // If enabled is not yet defined don't go any further.
    return null;
  }
  if (enabled) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(UseField, {
      key: "numericDetectionToggle",
      path: "dynamicMapping.numeric_detection",
      componentProps: {
        'data-test-subj': 'numericDetection'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(UseField, {
      path: "dynamicMapping.date_detection",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 15
      }
    }), dateDetection && /*#__PURE__*/_react.default.createElement(UseField, {
      path: "dynamicMapping.dynamic_date_formats",
      componentProps: {
        euiFieldProps: {
          options: _constants.ALL_DATE_FORMAT_OPTIONS,
          noSuggestions: false
        }
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 17
      }
    }));
  } else {
    return /*#__PURE__*/_react.default.createElement(UseField, {
      key: "throwErrorsCheckBox",
      path: "dynamicMapping.throwErrorsForUnmappedFields",
      component: _shared_imports.CheckBoxField,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 13
      }
    });
  }
}));
exports.DynamicMappingSection = DynamicMappingSection;