"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentTemplatesFlyoutWithContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _http = require("../../services/http");
var _notification = require("../../services/notification");
var _ui_metric = require("../../services/ui_metric");
var _services = require("../../services");
var _ui_metric2 = require("../../../../common/constants/ui_metric");
var _api = require("../../services/api");
var _ = require("../..");
var _component_template_details = require("./component_template_details");
var _shared_imports = require("./shared_imports");
var _locator = require("../../../locator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/component_templates/component_templates_flyout_with_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ComponentTemplatesFlyoutWithContext = ({
  core,
  dependencies,
  componentTemplateName,
  onClose,
  usageCollection
}) => {
  // this normally happens when the index management app is rendered
  // but if components are embedded elsewhere that setup is skipped, so we have to do it here
  // would do it in plugin.ts but that blows up the bundle size
  // can't do it in an effect because then the first http call fails as the instantiation happens after first render
  if (!_http.httpService.httpClient) {
    _http.httpService.setup(core.http);
    _notification.notificationService.setup(core.notifications);
  }
  _services.documentationService.setup(core.docLinks);
  const uiMetricService = new _ui_metric.UiMetricService(_ui_metric2.UIM_APP_NAME);
  (0, _api.setUiMetricService)(uiMetricService);
  uiMetricService.setup(usageCollection);
  const newDependencies = {
    ...dependencies,
    services: {
      ...(dependencies.services || {}),
      httpService: _http.httpService,
      notificationService: _notification.notificationService,
      uiMetricService
    }
  };
  const locator = dependencies.url.locators.get(_locator.INDEX_MANAGEMENT_LOCATOR_ID);
  const goToEditComponentTemplate = (0, _react.useCallback)(name => {
    locator === null || locator === void 0 ? void 0 : locator.navigate({
      page: 'edit_component_template',
      componentTemplate: name
    });
  }, [locator]);
  const goToCloneComponentTemplate = (0, _react.useCallback)(name => {
    locator === null || locator === void 0 ? void 0 : locator.navigate({
      page: 'clone_component_template',
      componentTemplate: name
    });
  }, [locator]);
  const actions = [{
    name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplateDetails.editButtonLabel', {
      defaultMessage: 'Edit'
    }),
    icon: 'pencil',
    handleActionClick: () => goToEditComponentTemplate((0, _shared_imports.attemptToURIDecode)(componentTemplateName))
  }, {
    name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplateDetails.cloneActionLabel', {
      defaultMessage: 'Clone'
    }),
    icon: 'copy',
    handleActionClick: () => goToCloneComponentTemplate((0, _shared_imports.attemptToURIDecode)(componentTemplateName))
  }];
  return /*#__PURE__*/_react.default.createElement(_.IndexManagementAppContext, {
    core: core,
    dependencies: newDependencies,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_component_template_details.ComponentTemplateDetailsFlyoutContent, {
    componentTemplateName: componentTemplateName,
    onClose: onClose,
    actions: actions,
    showSummaryCallToAction: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  })));
};
exports.ComponentTemplatesFlyoutWithContext = ComponentTemplatesFlyoutWithContext;