"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MappingsDsRolloverModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _documentation = require("../../../../services/documentation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/component_templates/component_template_wizard/component_template_ds_mappings/mappings_ds_rollover_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MappingsDsRolloverModal = ({
  componentTemplatename,
  dataStreams,
  onClose,
  api
}) => {
  const [error, setError] = (0, _react.useState)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const onConfirm = (0, _react.useCallback)(() => {
    async function confirm() {
      try {
        setIsLoading(true);
        for (const dataStream of dataStreams) {
          await api.postDataStreamRollover(dataStream);
        }
        await onClose();
      } catch (err) {
        setError(err);
      } finally {
        setIsLoading(false);
      }
    }
    confirm();
  }, [api, onClose, dataStreams]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "mappingDatastreamRolloverModal",
    isLoading: isLoading,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateEdit.mappingRolloverModalTitle",
      defaultMessage: "Apply mappings now and rollover?",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 9
      }
    }),
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    onCancel: onClose,
    onConfirm: onConfirm,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateMappingsRollover.cancelButton",
      defaultMessage: "Apply on next rollover",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 9
      }
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateMappingsRollover.confirmButtom",
      defaultMessage: "Apply now and rollover",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, error && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateMappingsRollover.saveError",
      defaultMessage: "Unable to apply rollover",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 15
      }
    }),
    color: "danger",
    iconType: "warning",
    "data-test-subj": "applyMappingsRolloverError",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 13
    }
  }, error.message)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplateMappingsRollover.modalDescription",
    defaultMessage: "New mappings for the {templateName} component template require a rollover for the following data streams: {datastreams} You can apply the new mappings to incoming data now and force a rollover, or wait until the next rollover. Rollover timing is defined by your index lifecycle policy. {moreInfoLink}",
    values: {
      templateName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 27
        }
      }, componentTemplatename),
      moreInfoLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        href: _documentation.documentationService.docLinks.fleet.datastreamsILM,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.componentTemplateEdit.moreInfoLink",
        defaultMessage: "See the documentation for more info.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 17
        }
      })),
      datastreams: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement("ul", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 17
        }
      }, dataStreams.map(dataStream => /*#__PURE__*/_react.default.createElement("li", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 124,
          columnNumber: 23
        }
      }, dataStream)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 17
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  })));
};
exports.MappingsDsRolloverModal = MappingsDsRolloverModal;