"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HomePublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _constants = require("../common/constants");
var _kibana_services = require("./application/kibana_services");
var _services = require("./services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class HomePublicPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "featuresCatalogueRegistry", new _services.FeatureCatalogueRegistry());
    (0, _defineProperty2.default)(this, "environmentService", new _services.EnvironmentService());
    (0, _defineProperty2.default)(this, "tutorialService", new _services.TutorialService());
    (0, _defineProperty2.default)(this, "addDataService", new _services.AddDataService());
    (0, _defineProperty2.default)(this, "welcomeService", new _services.WelcomeService());
    this.initializerContext = initializerContext;
  }
  setup(core, {
    cloud,
    share,
    urlForwarding,
    usageCollection
  }) {
    core.application.register({
      id: _constants.PLUGIN_ID,
      title: 'Home',
      visibleIn: [],
      mount: async params => {
        const trackUiMetric = usageCollection ? usageCollection.reportUiCounter.bind(usageCollection, 'Kibana_home') : () => {};
        const [coreStart, {
          dataViews,
          urlForwarding: urlForwardingStart,
          share: shareStart,
          cloud: cloudStart
        }] = await core.getStartServices();
        (0, _kibana_services.setServices)({
          share,
          trackUiMetric,
          kibanaVersion: this.initializerContext.env.packageInfo.version,
          http: coreStart.http,
          toastNotifications: coreStart.notifications.toasts,
          banners: coreStart.overlays.banners,
          docLinks: coreStart.docLinks,
          chrome: coreStart.chrome,
          application: coreStart.application,
          uiSettings: core.uiSettings,
          addBasePath: core.http.basePath.prepend,
          getBasePath: core.http.basePath.get,
          dataViewsService: dataViews,
          environmentService: this.environmentService,
          urlForwarding: urlForwardingStart,
          homeConfig: this.initializerContext.config.get(),
          tutorialService: this.tutorialService,
          addDataService: this.addDataService,
          featureCatalogue: this.featuresCatalogueRegistry,
          welcomeService: this.welcomeService,
          cloud,
          cloudStart,
          overlays: coreStart.overlays,
          theme: core.theme,
          i18nStart: coreStart.i18n,
          shareStart
        });
        coreStart.chrome.docTitle.change(_i18n.i18n.translate('home.pageTitle', {
          defaultMessage: 'Home'
        }));
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        return await renderApp(params.element, coreStart, params.history);
      }
    });
    urlForwarding.forwardApp('home', 'home');
    const featureCatalogue = {
      ...this.featuresCatalogueRegistry.setup()
    };
    featureCatalogue.register({
      id: 'home_tutorial_directory',
      title: _i18n.i18n.translate('home.tutorialDirectory.featureCatalogueTitle', {
        defaultMessage: 'Add data'
      }),
      description: _i18n.i18n.translate('home.tutorialDirectory.featureCatalogueDescription', {
        defaultMessage: 'Ingest data from popular apps and services.'
      }),
      icon: 'indexOpen',
      showOnHomePage: true,
      path: `${_constants.HOME_APP_BASE_PATH}#/tutorial_directory`,
      category: 'data',
      order: 500
    });
    const environment = {
      ...this.environmentService.setup()
    };
    const tutorials = {
      ...this.tutorialService.setup()
    };
    if (cloud) {
      environment.update({
        cloud: cloud.isCloudEnabled
      });
      if (cloud.isCloudEnabled) {
        var _cloud$profileUrl, _cloud$baseUrl, _cloud$deploymentUrl, _cloud$baseUrl2;
        tutorials.setVariable('cloud', {
          id: cloud.cloudId,
          baseUrl: cloud.baseUrl,
          // Cloud's API already provides the full URLs
          profileUrl: (_cloud$profileUrl = cloud.profileUrl) === null || _cloud$profileUrl === void 0 ? void 0 : _cloud$profileUrl.replace((_cloud$baseUrl = cloud.baseUrl) !== null && _cloud$baseUrl !== void 0 ? _cloud$baseUrl : '', ''),
          deploymentUrl: (_cloud$deploymentUrl = cloud.deploymentUrl) === null || _cloud$deploymentUrl === void 0 ? void 0 : _cloud$deploymentUrl.replace((_cloud$baseUrl2 = cloud.baseUrl) !== null && _cloud$baseUrl2 !== void 0 ? _cloud$baseUrl2 : '', '')
        });
      }
    }
    return {
      featureCatalogue,
      environment,
      tutorials,
      addData: {
        ...this.addDataService.setup()
      },
      welcomeScreen: {
        ...this.welcomeService.setup()
      }
    };
  }
  start({
    application: {
      capabilities
    }
  }) {
    this.featuresCatalogueRegistry.start({
      capabilities
    });
    return {
      featureCatalogue: this.featuresCatalogueRegistry
    };
  }
}

/** @public */

/** @public */

/** @public */

/** @public */

/** @public */
exports.HomePublicPlugin = HomePublicPlugin;