"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _homeSampleDataTab = require("@kbn/home-sample-data-tab");
var _home_app = require("./components/home_app");
var _kibana_services = require("./kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/home/public/application/application.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const renderApp = async (element, coreStart, history) => {
  const {
    featureCatalogue,
    chrome,
    dataViewsService: dataViews,
    trackUiMetric
  } = (0, _kibana_services.getServices)();

  // FIXME: use featureCatalogue.getFeatures$()
  const directories = featureCatalogue.get();

  // Filters solutions by available nav links
  const navLinksSubscription = chrome.navLinks.getNavLinks$().subscribe(navLinks => {
    const solutions = featureCatalogue.getSolutions().filter(({
      id
    }) => navLinks.find(({
      visibleIn,
      category
    }) => visibleIn.includes('home') && (category === null || category === void 0 ? void 0 : category.id) === id));
    (0, _reactDom.render)(coreStart.rendering.addContext(/*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
      coreStart: {
        application: coreStart.application
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: {
        ...coreStart
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_homeSampleDataTab.SampleDataTabKibanaProvider, {
      coreStart,
      dataViews,
      trackUiMetric,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_home_app.HomeApp, {
      directories: directories,
      solutions: solutions,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 15
      }
    }))))), element);
  });

  // dispatch synthetic hash change event to update hash history objects
  // this is necessary because hash updates triggered by using popState won't trigger this event naturally.
  // This must be called before the app is mounted to avoid call this after the redirect to default app logic kicks in
  const unlisten = history.listen(_location => {
    window.dispatchEvent(new HashChangeEvent('hashchange'));
  });
  return () => {
    (0, _reactDom.unmountComponentAtNode)(element);
    unlisten();
    navLinksSubscription.unsubscribe();
  };
};
exports.renderApp = renderApp;