"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Handlebars", {
  enumerable: true,
  get: function () {
    return _handlebars.default;
  }
});
var _handlebars = _interopRequireDefault(require("handlebars"));
var _visitor = require("./visitor");
/*
 * Elasticsearch B.V licenses this file to you under the MIT License.
 * See `src/platform/packages/private/kbn-handlebars/LICENSE` for more information.
 */

// The handlebars module uses `export =`, so we should technically use `import Handlebars = require('handlebars')`, but Babel will not allow this:
// https://www.typescriptlang.org/docs/handbook/modules.html#export--and-import--require

const originalCreate = _handlebars.default.create;
/**
 * Creates an isolated Handlebars environment.
 *
 * Each environment has its own helpers.
 * This is only necessary for use cases that demand distinct helpers.
 * Most use cases can use the root Handlebars environment directly.
 *
 * @returns A sandboxed/scoped version of the @kbn/handlebars module
 */
_handlebars.default.create = function () {
  const SandboxedHandlebars = originalCreate.call(_handlebars.default);
  // When creating new Handlebars environments, ensure the custom compileAST function is present in the new environment as well
  SandboxedHandlebars.compileAST = _handlebars.default.compileAST;
  return SandboxedHandlebars;
};
_handlebars.default.compileAST = function (input, options) {
  if (input == null || typeof input !== 'string' && input.type !== 'Program') {
    throw new _handlebars.default.Exception(`You must pass a string or Handlebars AST to Handlebars.compileAST. You passed ${input}`);
  }

  // If `Handlebars.compileAST` is reassigned, `this` will be undefined.
  const visitor = new _visitor.ElasticHandlebarsVisitor(this !== null && this !== void 0 ? this : _handlebars.default, input, options);
  return (context, runtimeOptions) => visitor.render(context, runtimeOptions);
};