"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEnabledFeatures = exports.EnabledFeaturesContextProvider = exports.EnabledFeaturesContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _use_kibana = require("../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/gen_ai_settings/public/contexts/enabled_features_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EnabledFeaturesContext = exports.EnabledFeaturesContext = /*#__PURE__*/(0, _react.createContext)({
  showSpacesIntegration: true,
  isPermissionsBased: false,
  showAiBreadcrumb: true,
  showAiAssistantsVisibilitySetting: true
});
const EnabledFeaturesContextProvider = ({
  children,
  config
}) => {
  var _services$spaces;
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const spaces = (_services$spaces = services === null || services === void 0 ? void 0 : services.spaces) !== null && _services$spaces !== void 0 ? _services$spaces : undefined;
  const activeSpace$ = _react.default.useMemo(() => {
    var _spaces$getActiveSpac, _spaces$getActiveSpac2;
    return (_spaces$getActiveSpac = spaces === null || spaces === void 0 ? void 0 : (_spaces$getActiveSpac2 = spaces.getActiveSpace$) === null || _spaces$getActiveSpac2 === void 0 ? void 0 : _spaces$getActiveSpac2.call(spaces)) !== null && _spaces$getActiveSpac !== void 0 ? _spaces$getActiveSpac : (0, _rxjs.of)(undefined);
  }, [spaces]);
  const activeSpace = (0, _useObservable.default)(activeSpace$);
  const contextFeatures = (0, _react.useMemo)(() => {
    const isSolutionView = Boolean((activeSpace === null || activeSpace === void 0 ? void 0 : activeSpace.solution) && activeSpace.solution !== 'classic');
    const showAiAssistantsVisibilitySetting = config.showAiAssistantsVisibilitySetting === false ? false : !isSolutionView;
    return {
      showSpacesIntegration: config.showSpacesIntegration,
      showAiBreadcrumb: config.showAiBreadcrumb,
      isPermissionsBased: isSolutionView,
      showAiAssistantsVisibilitySetting
    };
  }, [config, activeSpace]);
  return /*#__PURE__*/_react.default.createElement(EnabledFeaturesContext.Provider, {
    value: contextFeatures,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, children);
};
exports.EnabledFeaturesContextProvider = EnabledFeaturesContextProvider;
const useEnabledFeatures = () => {
  const context = (0, _react.useContext)(EnabledFeaturesContext);
  if (!context) {
    throw new Error('useEnabledFeatures must be used within EnabledFeaturesContextProvider');
  }
  return context;
};
exports.useEnabledFeatures = useEnabledFeatures;