"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.listHiddenTypes = exports.catchAndReturnBoomErrors = exports.KBN_CLIENT_API_PREFIX = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const KBN_CLIENT_API_PREFIX = exports.KBN_CLIENT_API_PREFIX = '/internal/ftr/kbn_client_so';
const listHiddenTypes = registry => {
  return registry.getAllTypes().map(type => type.name).filter(typeName => registry.isHidden(typeName));
};
exports.listHiddenTypes = listHiddenTypes;
const catchAndReturnBoomErrors = handler => {
  return async (context, request, response) => {
    try {
      return await handler(context, request, response);
    } catch (e) {
      if (_boom.default.isBoom(e) && e.output.statusCode !== 500) {
        return response.customError({
          body: e.output.payload,
          statusCode: e.output.statusCode,
          headers: e.output.headers
        });
      }
      throw e;
    }
  };
};
exports.catchAndReturnBoomErrors = catchAndReturnBoomErrors;