"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRemoteSyncedIntegrationsStatusHandler = exports.getRemoteSyncedIntegrationsInfoHandler = void 0;
var _compare_synced_integrations = require("../../tasks/sync_integrations/compare_synced_integrations");
var _get_remote_status = require("../../tasks/sync_integrations/get_remote_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRemoteSyncedIntegrationsStatusHandler = async (context, request, response) => {
  const coreContext = await context.core;
  const esClient = coreContext.elasticsearch.client.asInternalUser;
  const soClient = coreContext.savedObjects.client;
  try {
    const res = await (0, _compare_synced_integrations.getRemoteSyncedIntegrationsStatus)(esClient, soClient);
    return response.ok({
      body: res
    });
  } catch (error) {
    throw error;
  }
};
exports.getRemoteSyncedIntegrationsStatusHandler = getRemoteSyncedIntegrationsStatusHandler;
const getRemoteSyncedIntegrationsInfoHandler = async (context, request, response) => {
  const coreContext = await context.core;
  const soClient = coreContext.savedObjects.client;
  try {
    const res = await (0, _get_remote_status.getRemoteSyncedIntegrationsInfoByOutputId)(soClient, request.params.outputId);
    return response.ok({
      body: res
    });
  } catch (error) {
    throw error;
  }
};
exports.getRemoteSyncedIntegrationsInfoHandler = getRemoteSyncedIntegrationsInfoHandler;