"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetupTechnologySelector = exports.SETUP_TECHNOLOGY_SELECTOR_TEST_SUBJ = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../hooks");
var _types = require("../../common/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/services/setup_technology_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SETUP_TECHNOLOGY_SELECTOR_TEST_SUBJ = exports.SETUP_TECHNOLOGY_SELECTOR_TEST_SUBJ = 'setup-technology-selector';
const SetupTechnologySelector = ({
  disabled,
  allowedSetupTechnologies = [_types.SetupTechnology.AGENT_BASED, _types.SetupTechnology.AGENTLESS],
  setupTechnology,
  onSetupTechnologyChange,
  isAgentlessDefault = false,
  showBetaBadge = true,
  showLimitationsMessage = false,
  useDescribedFormGroup = true
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const currentSetupTechnology = setupTechnology || (isAgentlessDefault ? _types.SetupTechnology.AGENTLESS : _types.SetupTechnology.AGENT_BASED);
  const agentlessRadioId = `SetupTechnologySelector_${_types.SetupTechnology.AGENTLESS}`;
  const agentBasedRadioId = `SetupTechnologySelector_${_types.SetupTechnology.AGENT_BASED}`;
  const radioGroup = /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    disabled: disabled,
    name: "SetupTechnologySelector",
    "data-test-subj": SETUP_TECHNOLOGY_SELECTOR_TEST_SUBJ,
    idSelected: `SetupTechnologySelector_${currentSetupTechnology}`,
    options: [{
      id: agentlessRadioId,
      value: _types.SetupTechnology.AGENTLESS,
      disabled: !allowedSetupTechnologies.includes(_types.SetupTechnology.AGENTLESS),
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.setupTechnology.agentlessInputDisplay",
        defaultMessage: "Agentless",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 17
        }
      }), ' ', isAgentlessDefault ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.setupTechnology.agentlessDeployment.recommendedBadge",
        defaultMessage: "Recommended",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 21
        }
      })) : showBetaBadge && /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
        href: docLinks.links.fleet.agentlessIntegrations,
        target: "_blank",
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.setupTechnology.agentlessDeployment.betaBadge",
          defaultMessage: "Beta",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 89,
            columnNumber: 25
          }
        }),
        size: "s",
        tooltipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.setupTechnology.agentlessDeployment.betaTooltip",
          defaultMessage: "This module is not yet GA. Please help us by reporting any bugs.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 96,
            columnNumber: 25
          }
        }),
        alignment: "middle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 21
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 106,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.setupTechnology.agentlessInputDescription",
        defaultMessage: "Set up the integration without an agent",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 19
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 15
        }
      }))
    }, {
      id: agentBasedRadioId,
      value: _types.SetupTechnology.AGENT_BASED,
      disabled: !allowedSetupTechnologies.includes(_types.SetupTechnology.AGENT_BASED),
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 124,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.setupTechnology.agentbasedInputDisplay",
        defaultMessage: "Agent-based",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 125,
          columnNumber: 17
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.setupTechnology.agentbasedInputDescription",
        defaultMessage: "Deploy an Elastic Agent into your cloud environment",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 19
        }
      }))))
    }],
    onChange: (optionId, value) => {
      var _ref;
      const newSetupTechnology = (_ref = value) !== null && _ref !== void 0 ? _ref : optionId === agentlessRadioId ? _types.SetupTechnology.AGENTLESS : _types.SetupTechnology.AGENT_BASED;
      onSetupTechnologyChange(newSetupTechnology);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  });
  const limitationsMessage = showLimitationsMessage && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "alert",
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.setupTechnology.comingSoon",
      defaultMessage: "Agentless deployment is not supported if you are using {link}.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: "https://www.elastic.co/guide/en/cloud-enterprise/current/ece-traffic-filtering-deployment-configuration.html",
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 164,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.setupTechnology.comingSoon.trafficFilteringLinkText",
          defaultMessage: "Traffic filtering",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 168,
            columnNumber: 19
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 7
    }
  }));
  if (useDescribedFormGroup) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      title: /*#__PURE__*/_react.default.createElement("h3", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 186,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.setupTechnology.setupTechnologyLabel",
        defaultMessage: "Deployment options",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 187,
          columnNumber: 13
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.setupTechnology.setupTechnologyDescription",
        defaultMessage: "Select a deployment mode for this integration.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 195,
          columnNumber: 13
        }
      }), limitationsMessage),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 7
      }
    }, radioGroup);
  }

  // Used for security integrations (no form group wrapping)
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.setupTechnology.setupTechnologyLabel",
    defaultMessage: "Deployment options",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 11
    }
  }))), limitationsMessage || /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 30
    }
  }), radioGroup);
};
exports.SetupTechnologySelector = SetupTechnologySelector;