"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UninstallCommandsPerPlatform = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/components/uninstall_command_flyout/uninstall_commands_per_platform.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const generateUninstallCommands = token => ({
  linuxOrMac: `sudo elastic-agent uninstall --uninstall-token ${token}`,
  windows: `C:\\"Program Files"\\Elastic\\Agent\\elastic-agent.exe uninstall --uninstall-token ${token}`
});
const PLATFORM_OPTIONS = [{
  id: 'linuxOrMac',
  label: _i18n.i18n.translate('xpack.fleet.agentUninstallCommandFlyout.platformButtons.linuxOrMac', {
    defaultMessage: 'Linux or Mac'
  })
}, {
  id: 'windows',
  label: _i18n.i18n.translate('xpack.fleet.agentUninstallCommandFlyout.platformButtons.windows', {
    defaultMessage: 'Windows'
  })
}];
const UninstallCommandsPerPlatform = ({
  token
}) => {
  const [platform, setPlatform] = (0, _react.useState)('linuxOrMac');
  const commands = (0, _react.useMemo)(() => generateUninstallCommands(token), [token]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    options: PLATFORM_OPTIONS,
    idSelected: platform,
    onChange: id => setPlatform(id),
    legend: _i18n.i18n.translate('xpack.fleet.agentUninstallCommandFlyout.platformSelectAriaLabel', {
      defaultMessage: 'Platform'
    }),
    buttonSize: "m",
    "data-test-subj": "uninstall-commands-flyout-platforms-btn-group",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true,
    paddingSize: "m",
    "data-test-subj": "uninstall-commands-flyout-code-block",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, commands[platform]));
};
exports.UninstallCommandsPerPlatform = UninstallCommandsPerPlatform;