"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UninstallCommandFlyout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _hooks = require("../../hooks");
var _error = require("../error");
var _loading = require("../loading");
var _uninstall_tokens = require("../../hooks/use_request/uninstall_tokens");
var _constants = require("../../constants");
var _uninstall_commands_per_platform = require("./uninstall_commands_per_platform");
var _empty_policy_name_hint = require("./empty_policy_name_hint");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/components/uninstall_command_flyout/uninstall_command_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const UninstallAgentDescription = () => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentUninstallCommandFlyout.firstParagraph",
    defaultMessage: "Uninstall Elastic Agent and unenroll in Fleet to stop communicating with the host.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentUninstallCommandFlyout.subtitle",
    defaultMessage: "Uninstall Elastic Agent on your host",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentUninstallCommandFlyout.description",
    defaultMessage: "Select the appropriate platform and run the command to uninstall Elastic Agent. Reuse the command to uninstall agents on more than one host. {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.uninstallAgent,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.fleet.agentUninstallCommandFlyout.learnMore', {
        defaultMessage: 'Learn more'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  })));
};
const UninstallEndpointDescription = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("h3", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 78,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.endpointUninstallCommandFlyout.subtitle",
  defaultMessage: "Uninstall Elastic Defend integration on your host",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 79,
    columnNumber: 7
  }
})), /*#__PURE__*/_react.default.createElement("p", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 84,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.endpointUninstallCommandFlyout.description",
  defaultMessage: "Use the below uninstall command to uninstall Endpoint integration... [TODO]",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 85,
    columnNumber: 7
  }
})));
const ErrorFetchingUninstallToken = ({
  error
}) => /*#__PURE__*/_react.default.createElement(_error.Error, {
  title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentUninstallCommandFlyout.errorFetchingToken",
    defaultMessage: "Unable to fetch uninstall token",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }),
  error: error !== null && error !== void 0 ? error : _i18n.i18n.translate('xpack.fleet.agentUninstallCommandFlyout.unknownError', {
    defaultMessage: 'Unknown error'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 94,
    columnNumber: 3
  }
});
const UninstallCommandsByTokenId = ({
  uninstallTokenId
}) => {
  const theme = (0, _eui.useEuiTheme)();
  const {
    isLoading,
    error,
    data
  } = (0, _uninstall_tokens.useGetUninstallToken)(uninstallTokenId);
  const token = data === null || data === void 0 ? void 0 : data.item.token;
  const policyId = data === null || data === void 0 ? void 0 : data.item.policy_id;
  const policyName = data === null || data === void 0 ? void 0 : data.item.policy_name;
  return isLoading ? /*#__PURE__*/_react.default.createElement(_loading.Loading, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 5
    }
  }) : error || !token ? /*#__PURE__*/_react.default.createElement(ErrorFetchingUninstallToken, {
    error: error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_uninstall_commands_per_platform.UninstallCommandsPerPlatform, {
    token: token,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "uninstall-command-flyout-policy-id-hint",
    css: (0, _react2.css)`
          p {
            margin-block-end: ${theme.euiTheme.size.s};
          }
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentUninstallCommandFlyout.validForPolicyId",
    defaultMessage: "Valid for the following agent policy:",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }, policyName !== null && policyName !== void 0 ? policyName : /*#__PURE__*/_react.default.createElement(_empty_policy_name_hint.EmptyPolicyNameHint, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 26
    }
  }), " (", /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 52
    }
  }, policyId), ")")));
};
const UninstallCommandsByPolicyId = ({
  policyId
}) => {
  var _data$items, _data$items$;
  const {
    isLoading,
    error,
    data
  } = (0, _uninstall_tokens.useGetUninstallTokens)({
    policyId
  });
  const tokenId = data === null || data === void 0 ? void 0 : (_data$items = data.items) === null || _data$items === void 0 ? void 0 : (_data$items$ = _data$items[0]) === null || _data$items$ === void 0 ? void 0 : _data$items$.id;
  return isLoading ? /*#__PURE__*/_react.default.createElement(_loading.Loading, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 5
    }
  }) : error || !tokenId ? /*#__PURE__*/_react.default.createElement(ErrorFetchingUninstallToken, {
    error: error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(UninstallCommandsByTokenId, {
    uninstallTokenId: tokenId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 5
    }
  });
};
/** Flyout to show uninstall commands.
 *
 * Provide EITHER `policyId` OR `tokenId` for showing the token.
 */
const UninstallCommandFlyout = ({
  policyId,
  uninstallTokenId,
  onClose,
  target
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "data-test-subj": "uninstall-command-flyout",
    maxWidth: _constants.MAX_FLYOUT_WIDTH,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentUninstallCommandFlyout.title",
    defaultMessage: "Uninstall agent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 9
    }
  }, target === 'agent' ? /*#__PURE__*/_react.default.createElement(UninstallAgentDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 33
    }
  }) : /*#__PURE__*/_react.default.createElement(UninstallEndpointDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 65
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 9
    }
  }), uninstallTokenId ? /*#__PURE__*/_react.default.createElement(UninstallCommandsByTokenId, {
    uninstallTokenId: uninstallTokenId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 11
    }
  }) : policyId ? /*#__PURE__*/_react.default.createElement(UninstallCommandsByPolicyId, {
    policyId: policyId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 11
    }
  }) : null));
};
exports.UninstallCommandFlyout = UninstallCommandFlyout;