"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RollbackButton = RollbackButton;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../../../../../types");
var _hooks = require("../../../../../hooks");
var _use_installed_integrations_actions = require("../../installed_integrations/hooks/use_installed_integrations_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/settings/rollback_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function RollbackButton({
  packageInfo,
  isCustomPackage
}) {
  var _packageInfo$installa, _packageInfo$installa2;
  const canRollbackPackages = (0, _hooks.useAuthz)().integrations.installPackages;
  const hasPreviousVersion = !!(packageInfo !== null && packageInfo !== void 0 && (_packageInfo$installa = packageInfo.installationInfo) !== null && _packageInfo$installa !== void 0 && _packageInfo$installa.previous_version);
  const isUploadedPackage = ((_packageInfo$installa2 = packageInfo.installationInfo) === null || _packageInfo$installa2 === void 0 ? void 0 : _packageInfo$installa2.install_source) === 'upload';
  const isDisabled = !canRollbackPackages || !hasPreviousVersion || isUploadedPackage || isCustomPackage;
  const {
    actions: {
      bulkRollbackIntegrationsWithConfirmModal
    }
  } = (0, _use_installed_integrations_actions.useInstalledIntegrationsActions)();
  const rollbackPackage = (0, _hooks.useRollbackPackage)();
  const getPackageInstallStatus = (0, _hooks.useGetPackageInstallStatus)();
  const {
    status: installationStatus
  } = getPackageInstallStatus(packageInfo.name);
  const isRollingBack = installationStatus === _types.InstallStatus.rollingBack;
  const openRollbackModal = (0, _react.useCallback)(async () => {
    await rollbackPackage(packageInfo, bulkRollbackIntegrationsWithConfirmModal);
  }, [packageInfo, rollbackPackage, bulkRollbackIntegrationsWithConfirmModal]);
  const rollbackButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "rollbackButton",
    iconType: 'returnKey',
    isLoading: isRollingBack,
    onClick: openRollbackModal,
    color: "primary",
    disabled: isDisabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.rollbackPackage.rollbackPackageButtonLabel",
    defaultMessage: "Rollback {title}",
    values: {
      title: packageInfo.title
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isDisabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: !hasPreviousVersion ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrations.rollbackPackage.noVersionTooltip",
      defaultMessage: "You can't rollback this integration because it does not have a previous version saved.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 15
      }
    }) : !canRollbackPackages ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrations.rollbackPackage.noPermissionTooltip",
      defaultMessage: "You don't have permissions to rollback integrations. Contact your administrator.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 15
      }
    }) : isUploadedPackage ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrations.rollbackPackage.uploadedTooltip",
      defaultMessage: "This integration was installed by upload and cannot be rolled back.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 15
      }
    }) : isCustomPackage ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrations.rollbackPackage.customTooltip",
      defaultMessage: "Custom integrations cannot be rolled back.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 15
      }
    }) : null,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, rollbackButton) : rollbackButton);
}