"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUninstallPackage = exports.useSetPackageInstallStatus = exports.useRollbackPackage = exports.useInstallPackage = exports.useGetPackageInstallStatus = exports.PackageInstallProvider = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _hooks = require("../../../hooks");
var _types = require("../../../types");
var _services = require("../services");
var _ = require(".");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/hooks/use_package_install.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// TODO: Refactor this away from constate, which is unmaintained, as this is the only
// usage of it across the Fleet codebase
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function usePackageInstall({
  startServices
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    getPath
  } = (0, _hooks.useLink)();
  const [packages, setPackage] = (0, _react.useState)({});
  const confirmForceInstall = (0, _.useConfirmForceInstall)();
  const setPackageInstallStatus = (0, _react.useCallback)(({
    name,
    status,
    version
  }) => {
    const packageProps = {
      status,
      version
    };
    setPackage(prev => ({
      ...prev,
      [name]: packageProps
    }));
  }, []);
  const {
    notifications
  } = startServices;
  const getPackageInstallStatus = (0, _react.useCallback)(pkg => {
    return packages[pkg];
  }, [packages]);
  const optionallyForceInstall = async (installProps, prevStatus) => {
    const forceInstall = await confirmForceInstall(installProps);
    if (forceInstall) {
      return installPackage({
        ...installProps,
        force: true
      });
    } else {
      setPackageInstallStatus({
        ...prevStatus,
        name: installProps.name
      });
      return false;
    }
  };
  const installPackage = (0, _react.useCallback)(async props => {
    const {
      name,
      version,
      title,
      isReinstall = false,
      isUpgrade = false,
      force = false
    } = props;
    const prevStatus = getPackageInstallStatus(name);
    const newStatus = {
      ...prevStatus,
      name,
      status: isReinstall ? _types.InstallStatus.reinstalling : _types.InstallStatus.installing
    };
    setPackageInstallStatus(newStatus);
    try {
      const res = await (0, _hooks.sendInstallPackage)(name, version, isReinstall || force);
      if (res.error) {
        throw res.error;
      }
      setPackageInstallStatus({
        name,
        status: _types.InstallStatus.installed,
        version
      });
      if (isReinstall) {
        notifications.toasts.addSuccess({
          title: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.integrations.packageReinstallSuccessTitle",
            defaultMessage: "Reinstalled {title}",
            values: {
              title
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 111,
              columnNumber: 15
            }
          }), startServices),
          text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.integrations.packageReinstallSuccessDescription",
            defaultMessage: "Successfully reinstalled {title}",
            values: {
              title
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 119,
              columnNumber: 15
            }
          }), startServices)
        });
      } else if (isUpgrade) {
        notifications.toasts.addSuccess({
          title: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.integrations.packageUpgradeSuccessTitle",
            defaultMessage: "Upgraded {title}",
            values: {
              title
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 130,
              columnNumber: 15
            }
          }), startServices),
          text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.integrations.packageUpgradeSuccessDescription",
            defaultMessage: "Successfully upgraded {title}",
            values: {
              title
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 138,
              columnNumber: 15
            }
          }), startServices)
        });
      } else {
        notifications.toasts.addSuccess({
          title: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.integrations.packageInstallSuccessTitle",
            defaultMessage: "Installed {title}",
            values: {
              title
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 149,
              columnNumber: 15
            }
          }), startServices),
          text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.integrations.packageInstallSuccessDescription",
            defaultMessage: "Successfully installed {title}",
            values: {
              title
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 157,
              columnNumber: 15
            }
          }), startServices)
        });
      }
    } catch (error) {
      if ((0, _services.isVerificationError)(error)) {
        return optionallyForceInstall(props, prevStatus);
      }
      if (isUpgrade) {
        // if there is an error during update, set it back to the previous version
        // as handling of bad update is not implemented yet
        setPackageInstallStatus({
          ...prevStatus,
          name
        });
      } else {
        setPackageInstallStatus({
          name,
          status: _types.InstallStatus.notInstalled,
          version
        });
      }
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.fleet.integrations.packageInstallErrorTitle', {
          defaultMessage: 'Failed to install {title} package',
          values: {
            title
          }
        }),
        toastMessage: _i18n.i18n.translate('xpack.fleet.integrations.packageInstallErrorDescription', {
          defaultMessage: 'Something went wrong while trying to install this package. Please try again later.'
        })
      });
      return false;
    }
    return true;
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [getPackageInstallStatus, setPackageInstallStatus, startServices, getPath, history]);
  const uninstallPackage = (0, _react.useCallback)(async ({
    name,
    version,
    title,
    redirectToVersion
  }) => {
    setPackageInstallStatus({
      name,
      status: _types.InstallStatus.uninstalling,
      version
    });
    const res = await (0, _hooks.sendRemovePackage)({
      pkgName: name,
      pkgVersion: version
    });
    if (res.error) {
      setPackageInstallStatus({
        name,
        status: _types.InstallStatus.installed,
        version
      });
      notifications.toasts.addWarning({
        title: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.integrations.packageUninstallErrorTitle",
          defaultMessage: "Failed to uninstall {title} package",
          values: {
            title
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 210,
            columnNumber: 13
          }
        }), startServices),
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.integrations.packageUninstallErrorDescription",
          defaultMessage: "Something went wrong while trying to uninstall this package. Please try again later.",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 218,
            columnNumber: 13
          }
        }), startServices),
        iconType: 'error'
      });
    } else {
      setPackageInstallStatus({
        name,
        status: _types.InstallStatus.notInstalled,
        version: null
      });
      notifications.toasts.addSuccess({
        title: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.integrations.packageUninstallSuccessTitle",
          defaultMessage: "Uninstalled {title}",
          values: {
            title
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 231,
            columnNumber: 13
          }
        }), startServices),
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.integrations.packageUninstallSuccessDescription",
          defaultMessage: "Successfully uninstalled {title}",
          values: {
            title
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 239,
            columnNumber: 13
          }
        }), startServices)
      });
      if (redirectToVersion !== version) {
        const settingsPath = getPath('integration_details_settings', {
          pkgkey: `${name}-${redirectToVersion}`
        });
        history.push(settingsPath);
      }
    }
  }, [notifications.toasts, setPackageInstallStatus, getPath, history, startServices]);
  const rollbackPackage = (0, _react.useCallback)(async (packageInfo, bulkRollbackIntegrationsWithConfirmModal) => {
    var _packageInfo$installa;
    const {
      name,
      version
    } = packageInfo;
    const redirectToVersion = (_packageInfo$installa = packageInfo.installationInfo) === null || _packageInfo$installa === void 0 ? void 0 : _packageInfo$installa.previous_version;
    const result = await bulkRollbackIntegrationsWithConfirmModal([packageInfo], status => {
      setPackageInstallStatus({
        name,
        status: _types.InstallStatus.installed,
        version
      });
      if (status === 'success') {
        if (redirectToVersion !== version) {
          const settingsPath = getPath('integration_details_settings', {
            pkgkey: `${name}-${redirectToVersion}`
          });
          history.push(settingsPath);
        }
      }
    });
    if (result === 'confirmed') {
      setPackageInstallStatus({
        name,
        status: _types.InstallStatus.rollingBack,
        version
      });
    }
  }, [setPackageInstallStatus, getPath, history]);
  return {
    packages,
    installPackage,
    setPackageInstallStatus,
    getPackageInstallStatus,
    uninstallPackage,
    rollbackPackage
  };
}
const [PackageInstallProvider, useInstallPackage, useSetPackageInstallStatus, useGetPackageInstallStatus, useUninstallPackage, useRollbackPackage] = (0, _constate.default)(usePackageInstall, value => value.installPackage, value => value.setPackageInstallStatus, value => value.getPackageInstallStatus, value => value.uninstallPackage, value => value.rollbackPackage);
exports.useRollbackPackage = useRollbackPackage;
exports.useUninstallPackage = useUninstallPackage;
exports.useGetPackageInstallStatus = useGetPackageInstallStatus;
exports.useSetPackageInstallStatus = useSetPackageInstallStatus;
exports.useInstallPackage = useInstallPackage;
exports.PackageInstallProvider = PackageInstallProvider;