"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchIdField = exports.fieldsToSearch = void 0;
exports.useLocalSearch = useLocalSearch;
var _jsSearch = require("js-search");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const searchIdField = exports.searchIdField = 'id';
const fieldsToSearch = exports.fieldsToSearch = ['name', 'title', 'description'];
function useLocalSearch(packageList, isInitialLoading) {
  return (0, _react.useMemo)(() => {
    if (isInitialLoading) {
      return null;
    }
    const localSearch = new _jsSearch.Search(searchIdField);
    localSearch.indexStrategy = new _jsSearch.PrefixIndexStrategy();
    fieldsToSearch.forEach(field => localSearch.addIndex(field));
    localSearch.addDocuments(packageList);
    return localSearch;
  }, [isInitialLoading, packageList]);
}