"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ensurePackageKibanaAssetsInstalled = ensurePackageKibanaAssetsInstalled;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/spaces-plugin/common");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function ensurePackageKibanaAssetsInstalled({
  pkgName,
  pkgVersion,
  toasts,
  ...rest
}) {
  try {
    var _installationInfo$ins, _installationInfo$add;
    const packageInfo = await (0, _hooks.sendGetPackageInfoByKeyForRq)(pkgName, pkgVersion, {
      prerelease: true
    });
    const installationInfo = packageInfo.item.installationInfo;
    if (!installationInfo) {
      // Skip if package is not installed
      return;
    }
    const kibanaAssetsSpaces = [(_installationInfo$ins = installationInfo.installed_kibana_space_id) !== null && _installationInfo$ins !== void 0 ? _installationInfo$ins : _common.DEFAULT_SPACE_ID, ...Object.keys((_installationInfo$add = installationInfo.additional_spaces_installed_kibana) !== null && _installationInfo$add !== void 0 ? _installationInfo$add : {})];
    if ('currentSpaceId' in rest) {
      if (kibanaAssetsSpaces.includes(rest.currentSpaceId)) {
        return;
      }
      await (0, _hooks.sendInstallKibanaAssetsForRq)({
        pkgName: installationInfo.name,
        pkgVersion: installationInfo.version
      });
    } else {
      const missingSpaceIds = rest.spaceIds.filter(spaceId => !kibanaAssetsSpaces.includes(spaceId));
      if (!missingSpaceIds.length) {
        return;
      }
      await (0, _hooks.sendInstallKibanaAssetsForRq)({
        pkgName: installationInfo.name,
        pkgVersion: installationInfo.version,
        spaceIds: missingSpaceIds
      });
    }
    toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.installKibanaAssets.successNotificationTitle', {
      defaultMessage: 'Successfully installed kibana assets for {pkgName}',
      values: {
        pkgName: installationInfo.name
      }
    }));
  } catch (err) {
    toasts.addError(err, {
      title: _i18n.i18n.translate('xpack.fleet.installKibanaAssets.errorNotificationTitle', {
        defaultMessage: 'Unable to install kibana assets for {pkgName}',
        values: {
          pkgName
        }
      })
    });
  }
}