"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamRowActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
var _components = require("../../../../components");
var _use_apm_service_href = require("../../../../hooks/use_apm_service_href");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/data_stream/list_page/components/data_stream_row_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DataStreamRowActions = exports.DataStreamRowActions = /*#__PURE__*/(0, _react.memo)(({
  datastream
}) => {
  const {
    dashboards
  } = datastream;
  const dashboardLocator = (0, _hooks.useDashboardLocator)();
  const actionNameSingular = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.dataStreamList.viewDashboardActionText",
    defaultMessage: "View dashboard",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  });
  const actionNamePlural = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.dataStreamList.viewDashboardsActionText",
    defaultMessage: "View dashboards",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  });
  const panelTitle = _i18n.i18n.translate('xpack.fleet.dataStreamList.viewDashboardsPanelTitle', {
    defaultMessage: 'View dashboards'
  });
  const viewServiceInApmActionTitle = _i18n.i18n.translate('xpack.fleet.dataStreamList.viewInApmActionText', {
    defaultMessage: 'View in APM'
  });
  const {
    isSuccessful,
    href
  } = (0, _use_apm_service_href.useAPMServiceDetailHref)(datastream);
  if (isSuccessful && href) {
    const apmItem = [{
      id: 0,
      items: [{
        icon: 'apmApp',
        href,
        name: viewServiceInApmActionTitle
      }]
    }];
    return /*#__PURE__*/_react.default.createElement(_components.ContextMenuActions, {
      panels: apmItem,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 12
      }
    });
  }
  if (!dashboards || dashboards.length === 0) {
    const disabledItems = [{
      id: 0,
      items: [{
        icon: 'dashboardApp',
        disabled: true,
        name: actionNameSingular
      }]
    }];
    return /*#__PURE__*/_react.default.createElement(_components.ContextMenuActions, {
      panels: disabledItems,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 12
      }
    });
  }
  if (dashboards.length === 1) {
    var _dashboards$;
    const panelItems = [{
      id: 0,
      items: [{
        icon: 'dashboardApp',
        href: dashboardLocator === null || dashboardLocator === void 0 ? void 0 : dashboardLocator.getRedirectUrl({
          dashboardId: (_dashboards$ = dashboards[0]) === null || _dashboards$ === void 0 ? void 0 : _dashboards$.id
        } || ''),
        name: actionNameSingular
      }]
    }];
    return /*#__PURE__*/_react.default.createElement(_components.ContextMenuActions, {
      panels: panelItems,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 12
      }
    });
  }
  const panelItems = [{
    id: 0,
    items: [{
      icon: 'dashboardApp',
      panel: 1,
      name: actionNamePlural
    }]
  }, {
    id: 1,
    title: panelTitle,
    items: dashboards.map(dashboard => {
      return {
        icon: 'dashboardApp',
        href: dashboardLocator === null || dashboardLocator === void 0 ? void 0 : dashboardLocator.getRedirectUrl({
          dashboardId: dashboard === null || dashboard === void 0 ? void 0 : dashboard.id
        } || ''),
        name: dashboard.title
      };
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_components.ContextMenuActions, {
    panels: panelItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 10
    }
  });
});