"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradeInProgressActivityItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _hooks = require("../../../../../hooks");
var _helpers = require("./helpers");
var _view_agents_button = require("./view_agents_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/agent_activity_flyout/upgrade_in_progress_activity_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Divider = _styled.default.div`
  width: 0;
  height: 50%;
  border-left: ${props => props.theme.euiTheme.border.thin};
  position: relative;
  top: 50%;
  transform: translateY(-50%);
`;
const UpgradeInProgressActivityItem = ({
  action,
  abortUpgrade,
  onClickViewAgents,
  onClickManageAutoUpgradeAgents
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const theme = (0, _eui.useEuiTheme)();
  const isAutomaticUpgrade = action.is_automatic;
  const [isAborting, setIsAborting] = (0, _react.useState)(false);
  const onClickAbortUpgrade = (0, _react.useCallback)(async () => {
    try {
      setIsAborting(true);
      await abortUpgrade(action);
    } finally {
      setIsAborting(false);
    }
  }, [action, abortUpgrade]);
  const isScheduled = (0, _react.useMemo)(() => {
    if (!action.startTime) {
      return false;
    }
    const now = Date.now();
    const startDate = new Date(action.startTime).getTime();
    return startDate > now;
  }, [action]);
  const showCancelButton = (0, _react.useMemo)(() => {
    return isScheduled || action.hasRolloutPeriod;
  }, [action, isScheduled]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    borderRadius: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "upgradeInProgressDescription",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }, isScheduled && action.startTime ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.scheduledDescription",
    defaultMessage: "Scheduled for ",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 19
    }
  }, (0, _helpers.formattedTime)(action.startTime)), ".\xA0") : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _helpers.inProgressDescription)(action.creationTime), "\xA0")))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  }, isScheduled ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "clock",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 30
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 57
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: theme.euiTheme.colors.textPrimary,
    "data-test-subj": "upgradeInProgressTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 15
    }
  }, isScheduled && action.startTime ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.scheduleTitle",
    defaultMessage: "{nbAgents} agents scheduled to upgrade to version {version}",
    values: {
      nbAgents: action.nbAgentsActioned - action.nbAgentsAck,
      version: action.version
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 19
    }
  }) : (0, _helpers.inProgressTitle)(action, isAutomaticUpgrade))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_view_agents_button.ViewAgentsButton, {
    action: action,
    onClickViewAgents: onClickViewAgents,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(Divider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 17
    }
  })), isAutomaticUpgrade && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "manageAutoUpgradesButton",
    onClick: () => onClickManageAutoUpgradeAgents(action),
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.manageAutoUpgradeAgents",
    defaultMessage: "Manage auto-upgrade agents",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 23
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(Divider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.fleet.upgradeElasticAgent,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.guideLink",
    defaultMessage: "Learn more",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 21
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 13
    }
  }, showCancelButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    onClick: onClickAbortUpgrade,
    isLoading: isAborting,
    "data-test-subj": "abortBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.abortUpgradeButtom",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 19
    }
  })) : null)))));
};
exports.UpgradeInProgressActivityItem = UpgradeInProgressActivityItem;