"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColorSeriesAccessorFn = getColorSeriesAccessorFn;
var _coloring = require("@kbn/coloring");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Return a color accessor function for XY charts depending on the split accessors received.
 */
function getColorSeriesAccessorFn(config, invertedRawValueMap, palettes, isDarkMode, mappingData, fieldId) {
  var _invertedRawValueMap$;
  const getColor = (0, _coloring.getColorFactory)(config, palettes, isDarkMode, mappingData);
  const rawValueMap = (_invertedRawValueMap$ = invertedRawValueMap.get(fieldId)) !== null && _invertedRawValueMap$ !== void 0 ? _invertedRawValueMap$ : new Map();
  return ({
    splitAccessors
  }) => {
    var _rawValueMap$get;
    const splitValue = splitAccessors.get(fieldId);

    // No category associated in the split accessor, use the default color
    if (splitValue === undefined) return null;
    const rawValue = typeof splitValue === 'string' ? (_rawValueMap$get = rawValueMap.get(splitValue)) !== null && _rawValueMap$get !== void 0 ? _rawValueMap$get : splitValue : splitValue;
    return getColor(rawValue);
  };
}